import React from 'react';
import type { ReactComponentOrElement } from '../models';
interface IonOverlayManagerProps {
    onAddOverlay: (callback: (id: string, component: ReactComponentOrElement, containerElement: HTMLDivElement) => void) => void;
    onRemoveOverlay: (callback: (id: string) => void) => void;
}
/**
 * Manages overlays that are added via the useOverlay hook.
 * This is a standalone component so changes to its children don't cause other descendant
 * components to re-render when overlays are added. However, we need to communicate with the IonContext
 * that is set up in <IonApp />, so we register callbacks so when overlays are added to IonContext,
 * they ultimately added here.
 */
export declare const IonOverlayManager: React.FC<IonOverlayManagerProps>;
export {};
