"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const PropertySymbol = __importStar(require("../PropertySymbol.cjs"));
const ErrorEvent_js_1 = __importDefault(require("../event/events/ErrorEvent.cjs"));
/**
 * Error utility.
 */
class WindowErrorUtility {
    /**
     * Calls a function synchronously wrapped in a try/catch block to capture errors and dispatch error events.
     * If the callback returns a Promise, it will catch errors from the promise.
     *
     * It will also output the errors to the console.
     *
     * @param elementOrWindow Element or Window.
     * @param callback Callback.
     * @param [cleanup] Cleanup callback on error.
     * @returns Result.
     */
    static captureError(elementOrWindow, callback, cleanup) {
        let result = null;
        try {
            result = callback();
        }
        catch (error) {
            this.dispatchError(elementOrWindow, error);
            if (cleanup) {
                cleanup();
            }
        }
        if (result && result instanceof Promise) {
            result.catch((error) => {
                this.dispatchError(elementOrWindow, error);
                if (cleanup) {
                    cleanup();
                }
            });
        }
        return result;
    }
    /**
     * Dispatches an error event and outputs it to the console.
     *
     * @param elementOrWindow Element or Window.
     * @param error Error.
     */
    static dispatchError(elementOrWindow, error) {
        if (elementOrWindow.console) {
            elementOrWindow.console.error(error);
            elementOrWindow.dispatchEvent(new ErrorEvent_js_1.default('error', { message: error.message, error }));
        }
        else {
            elementOrWindow[PropertySymbol.ownerDocument][PropertySymbol.defaultView].console.error(error);
            elementOrWindow.dispatchEvent(new ErrorEvent_js_1.default('error', { message: error.message, error }));
        }
    }
}
exports.default = WindowErrorUtility;
//# sourceMappingURL=WindowErrorUtility.cjs.map