'use strict'
Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' })
let sortNodesByDependencies = (nodes, extraOptions) => {
  let result = []
  let visitedNodes = /* @__PURE__ */ new Set()
  let inProcessNodes = /* @__PURE__ */ new Set()
  let visitNode = sortingNode => {
    if (visitedNodes.has(sortingNode)) {
      return
    }
    if (inProcessNodes.has(sortingNode)) {
      return
    }
    inProcessNodes.add(sortingNode)
    let dependentNodes = nodes.filter(({ dependencyName, name }) =>
      sortingNode.dependencies.includes(dependencyName ?? name),
    )
    for (let dependentNode of dependentNodes) {
      if (
        !extraOptions.ignoreEslintDisabledNodes ||
        !dependentNode.isEslintDisabled
      ) {
        visitNode(dependentNode)
      }
    }
    visitedNodes.add(sortingNode)
    inProcessNodes.delete(sortingNode)
    result.push(sortingNode)
  }
  for (let node of nodes) {
    visitNode(node)
  }
  return result
}
let getFirstUnorderedNodeDependentOn = (node, currentlyOrderedNodes) => {
  let nodesDependentOnNode = currentlyOrderedNodes.filter(
    currentlyOrderedNode =>
      currentlyOrderedNode.dependencies.includes(
        node.dependencyName ?? node.name,
      ),
  )
  return nodesDependentOnNode.find(firstNodeDependentOnNode => {
    let currentIndexOfNode = currentlyOrderedNodes.indexOf(node)
    let currentIndexOfFirstNodeDependentOnNode = currentlyOrderedNodes.indexOf(
      firstNodeDependentOnNode,
    )
    return currentIndexOfFirstNodeDependentOnNode < currentIndexOfNode
  })
}
exports.getFirstUnorderedNodeDependentOn = getFirstUnorderedNodeDependentOn
exports.sortNodesByDependencies = sortNodesByDependencies
