"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OPS = void 0;
const path_1 = require("path");
const project_1 = require("@trapezedev/project");
function getJsonFile(path, vfs) {
    const existing = vfs.get(path);
    if (existing) {
        return existing.getData();
    }
    return new project_1.JsonFile(path, vfs);
}
async function execute(ctx, op) {
    const jsonOp = op;
    const entries = jsonOp.value;
    for (const entry of entries) {
        let filename = entry.file;
        if (!filename) {
            continue;
        }
        let jsonFile = getJsonFile((0, path_1.join)(ctx.project.projectRoot, filename), ctx.project.vfs);
        await jsonFile.load();
        if (entry.set) {
            jsonFile.set(entry.set);
        }
        if (entry.merge) {
            jsonFile.merge(entry.merge);
        }
    }
}
exports.default = execute;
exports.OPS = [
    'project.json'
];
//# sourceMappingURL=json.js.map