"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OPS = void 0;
const log_1 = require("../../util/log");
async function execute(ctx, op) {
    const copyOp = op;
    for (let c of copyOp.value) {
        try {
            const { src, dest } = c;
            await ctx.project.copyFile(src, dest);
        }
        catch (e) {
            log_1.logger.warn(`Unable to copy file: ${e.message}`);
        }
    }
    return [];
}
exports.default = execute;
exports.OPS = [
    'project.copy'
];
//# sourceMappingURL=copy.js.map