import { resolveConfig as resolveConfig$1, mergeConfig, createServer as createServer$1 } from 'vite';
export { esbuildVersion, isFileServingAllowed, parseAst, parseAstAsync, rollupVersion, version as viteVersion } from 'vite';
import { V as Vitest, a as VitestPlugin } from './chunks/cli-api.CETCDGgZ.js';
export { G as GitNotFoundError, F as TestsNotFoundError, b as VitestPackageInstaller, e as createViteLogger, c as createVitest, d as registerConsoleShortcuts, r as resolveFsAllow, s as startVitest } from './chunks/cli-api.CETCDGgZ.js';
import { f as TestModule } from './chunks/index.9ZEBV_TJ.js';
export { p as parseCLI } from './chunks/cac.Xzv7eNWw.js';
import { a as resolveConfig$2 } from './chunks/resolveConfig.BA-_OKEx.js';
export { d as createMethodsRPC, g as getFilePoolName, b as resolveApiServerConfig } from './chunks/resolveConfig.BA-_OKEx.js';
import { slash } from '@vitest/utils';
import { f as findUp } from './chunks/index.BJDntFik.js';
import { resolve } from 'pathe';
import { c as configFiles } from './chunks/constants.fzPh7AOq.js';
export { B as BaseSequencer } from './chunks/RandomSequencer.gisBJ77r.js';
export { distDir, rootDir } from './path.js';
import createDebug from 'debug';
export { generateFileHash } from '@vitest/runner/utils';
import 'node:fs';
import './chunks/coverage.BWeNbfBa.js';
import 'node:path';
import '@vitest/snapshot/manager';
import 'vite-node/client';
import 'vite-node/server';
import './chunks/index.68735LiX.js';
import 'stream';
import 'zlib';
import 'buffer';
import 'crypto';
import 'events';
import 'https';
import 'http';
import 'net';
import 'tls';
import 'url';
import './chunks/_commonjsHelpers.BFTU3MAI.js';
import '@vitest/utils/source-map';
import 'node:module';
import 'node:url';
import 'tinyrainbow';
import 'std-env';
import 'node:fs/promises';
import 'node:os';
import 'os';
import 'path';
import 'fs';
import 'vite-node/utils';
import '@vitest/mocker/node';
import 'magic-string';
import 'node:readline';
import 'node:util';
import './chunks/utils.CMUTX-p8.js';
import 'node:perf_hooks';
import 'node:stream';
import 'node:console';
import 'node:process';
import 'assert';
import 'node:assert';
import 'node:v8';
import 'util';
import 'node:events';
import 'tinypool';
import 'node:worker_threads';
import 'readline';
import 'tinyexec';
import 'node:crypto';

async function resolveConfig(options = {}, viteOverrides = {}) {
  const root = slash(resolve(options.root || process.cwd()));
  const configPath = options.config === false ? false : options.config ? resolve(root, options.config) : await findUp(configFiles, { cwd: root });
  options.config = configPath;
  const vitest = new Vitest("test");
  const config = await resolveConfig$1(
    mergeConfig(
      {
        configFile: configPath,
        // this will make "mode": "test" | "benchmark" inside defineConfig
        mode: options.mode || "test",
        plugins: [
          await VitestPlugin(options, vitest)
        ]
      },
      mergeConfig(viteOverrides, { root: options.root })
    ),
    "serve"
  );
  const updatedOptions = Reflect.get(config, "_vitest");
  const vitestConfig = resolveConfig$2(
    "test",
    updatedOptions,
    config,
    vitest.logger
  );
  return {
    viteConfig: config,
    vitestConfig
  };
}

function createDebugger(namespace) {
  const debug = createDebug(namespace);
  if (debug.enabled) {
    return debug;
  }
}

const version = Vitest.version;
const createServer = createServer$1;
const createViteServer = createServer$1;
const TestFile = TestModule;

export { TestFile, VitestPlugin, createDebugger, createServer, createViteServer, resolveConfig, version };
