"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const lodash_uniqwith_1 = __importDefault(require("lodash.uniqwith"));
const lodash_isequal_1 = __importDefault(require("lodash.isequal"));
const constants_1 = __importDefault(require("../config/constants"));
const mapToIconImageFileObj = (fileNamePrefix, width, height) => ({
    name: `${fileNamePrefix}-${width}${height ? `-${height}` : ''}`,
    width,
    height: height !== null && height !== void 0 ? height : width,
    orientation: null,
    scaleFactor: 1,
});
const mapToImageFileObj = (fileNamePrefix, width, height, scaleFactor, orientation) => ({
    name: `${fileNamePrefix}-${width}-${height}`,
    width,
    height,
    scaleFactor,
    orientation,
});
const getIconImages = (options) => {
    let icons = [
        ...constants_1.default.APPLE_ICON_SIZES.map((size) => mapToIconImageFileObj(constants_1.default.APPLE_ICON_FILENAME_PREFIX, size)),
        ...constants_1.default.MANIFEST_ICON_SIZES.map((size) => mapToIconImageFileObj(constants_1.default.MANIFEST_ICON_FILENAME_PREFIX, size)),
    ];
    if (options.favicon) {
        icons = [
            ...icons,
            ...constants_1.default.FAVICON_SIZES.map((size) => mapToIconImageFileObj(constants_1.default.FAVICON_FILENAME_PREFIX, size)),
        ];
    }
    if (options.mstile) {
        icons = [
            ...icons,
            ...constants_1.default.MS_ICON_SIZES.map((size) => {
                if (typeof size === 'object') {
                    return mapToIconImageFileObj(constants_1.default.MS_ICON_FILENAME_PREFIX, size.width, size.height);
                }
                return mapToIconImageFileObj(constants_1.default.MS_ICON_FILENAME_PREFIX, size);
            }),
        ];
    }
    return (0, lodash_uniqwith_1.default)(icons, lodash_isequal_1.default);
};
const getSplashScreenImages = (splashScreenData, options) => {
    let appleSplashFilenamePrefix = constants_1.default.APPLE_SPLASH_FILENAME_PREFIX;
    if (options.darkMode) {
        appleSplashFilenamePrefix +=
            constants_1.default.APPLE_SPLASH_FILENAME_DARK_MODE_POSTFIX;
    }
    return (0, lodash_uniqwith_1.default)(splashScreenData.reduce((acc, curr) => {
        let images = acc;
        if (!options.landscapeOnly) {
            images = [
                ...images,
                mapToImageFileObj(appleSplashFilenamePrefix, curr.portrait.width, curr.portrait.height, curr.scaleFactor, 'portrait'),
            ];
        }
        if (!options.portraitOnly) {
            images = [
                ...images,
                mapToImageFileObj(appleSplashFilenamePrefix, curr.landscape.width, curr.landscape.height, curr.scaleFactor, 'landscape'),
            ];
        }
        return images;
    }, []), lodash_isequal_1.default);
};
exports.default = {
    getIconImages,
    getSplashScreenImages,
};
//# sourceMappingURL=images.js.map