"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.killBrowser = void 0;
const puppeteer_core_1 = __importDefault(require("puppeteer-core"));
const chrome_launcher_1 = require("chrome-launcher");
const find_process_1 = __importDefault(require("find-process"));
const http_1 = require("http");
const logger_1 = __importDefault(require("./logger"));
const constants_1 = __importDefault(require("../config/constants"));
const installer_1 = __importDefault(require("./installer"));
const isPreferredBrowserRevisionInstalled = () => {
    const revisionInfo = installer_1.default.getPreferredBrowserRevisionInfo();
    return revisionInfo.local;
};
const getLocalRevisionList = () => {
    return installer_1.default.getBrowserFetcher().localRevisions();
};
const getLocalRevisionInfo = () => __awaiter(void 0, void 0, void 0, function* () {
    if (isPreferredBrowserRevisionInstalled()) {
        return installer_1.default.getPreferredBrowserRevisionInfo();
    }
    const localRevisions = yield getLocalRevisionList();
    if (localRevisions.length > 0) {
        const lastRevision = localRevisions.pop();
        return installer_1.default.getBrowserFetcher().revisionInfo(lastRevision);
    }
    return undefined;
});
const getLocalBrowserInstance = (launchArgs, noSandbox) => __awaiter(void 0, void 0, void 0, function* () {
    var _a;
    let revisionInfo;
    const localRevisionInfo = yield getLocalRevisionInfo();
    if (localRevisionInfo) {
        revisionInfo = localRevisionInfo;
    }
    else {
        revisionInfo = yield installer_1.default.installPreferredBrowserRevision();
    }
    return puppeteer_core_1.default.launch(Object.assign(Object.assign(Object.assign({}, launchArgs), (noSandbox && {
        args: [
            ...((_a = launchArgs.args) !== null && _a !== void 0 ? _a : []),
            '--no-sandbox',
            '--disable-setuid-sandbox',
        ],
    })), { executablePath: revisionInfo.executablePath }));
});
const launchSystemBrowser = () => {
    const launchOptions = {
        chromeFlags: constants_1.default.CHROME_LAUNCH_ARGS,
        logLevel: 'silent',
        maxConnectionRetries: constants_1.default.CHROME_LAUNCHER_MAX_CONN_RETRIES,
    };
    return (0, chrome_launcher_1.launch)(launchOptions);
};
const getLaunchedChromeVersionInfo = (chrome) => {
    return new Promise((resolve, reject) => {
        (0, http_1.get)(`http://localhost:${chrome.port}/json/version`, (res) => {
            let data = '';
            res.setEncoding('utf8');
            res.on('data', (chunk) => {
                data += chunk;
            });
            res.on('end', () => {
                resolve(JSON.parse(data));
            });
        }).on('error', (err) => reject(err));
    });
};
const getSystemBrowserInstance = (chrome, launchArgs) => __awaiter(void 0, void 0, void 0, function* () {
    const chromeVersionInfo = yield getLaunchedChromeVersionInfo(chrome);
    return puppeteer_core_1.default.connect(Object.assign(Object.assign({}, launchArgs), { browserWSEndpoint: chromeVersionInfo.webSocketDebuggerUrl }));
});
const getBrowserInstance = (launchArgs, noSandbox) => __awaiter(void 0, void 0, void 0, function* () {
    const LAUNCHER_CONNECTION_REFUSED_ERROR_CODE = 'ECONNREFUSED';
    const LAUNCHER_NOT_INSTALLED_ERROR_CODE = 'ERR_LAUNCHER_NOT_INSTALLED';
    const logger = (0, logger_1.default)(getBrowserInstance.name);
    let browser;
    let chrome;
    try {
        chrome = yield launchSystemBrowser();
        browser = yield getSystemBrowserInstance(chrome, launchArgs);
    }
    catch (e) {
        const error = e;
        // Kill chrome instance manually in case of connection error
        if (error.code === LAUNCHER_CONNECTION_REFUSED_ERROR_CODE) {
            logger.warn(`Chrome launcher could not connect to your system browser. Is your port ${error.port} accessible?`);
            const prc = yield (0, find_process_1.default)('port', error.port);
            prc.forEach((pr) => {
                logger.log(`Killing incompletely launched system chrome instance on pid ${pr.pid}`);
                process.kill(pr.pid);
            });
        }
        // Inform user that system chrome is not found
        if (error.code === LAUNCHER_NOT_INSTALLED_ERROR_CODE) {
            logger.warn('Looks like Chrome is not installed on your system');
        }
        browser = yield getLocalBrowserInstance(launchArgs, noSandbox);
    }
    return { browser, chrome };
});
const killBrowser = (browser, chrome) => __awaiter(void 0, void 0, void 0, function* () {
    if (chrome) {
        yield browser.disconnect();
        yield chrome.kill();
    }
    else {
        yield browser.close();
    }
});
exports.killBrowser = killBrowser;
exports.default = {
    getBrowserInstance,
    killBrowser: exports.killBrowser,
};
//# sourceMappingURL=browser.js.map