/**
 * @typedef {import('micromark-util-types').Extension} Extension
 */

import { spoiler as spoilerExtension } from './spoiler.js';

/**
 * Create an extension for `micromark` to enable lemmy spoiler syntax.
 *
 * @returns {Extension}
 *   Extension for `micromark` that can be passed in `extensions`, to
 *   enable lemmy spoiler syntax.
 */
export function spoiler() {
  return {
    flow: {
      [58]: [spoilerExtension]
    }
  };
}