import type { OAuthProviderId } from "./OAuthProviderId";
/**
 * Logging in with an OAuth 2.0 authorization
 */
export type AuthenticateWithOauth = {
    code: string;
    oauth_provider_id: OAuthProviderId;
    redirect_uri: string;
    show_nsfw?: boolean;
    /**
     * Username is mandatory at registration time
     */
    username?: string;
    /**
     * An answer is mandatory if require application is enabled on the server
     */
    answer?: string;
};
