<!-- Please do not edit this file. Edit the `blah` field in the `package.json` instead. If in doubt, open an issue. -->








[![is-there](http://i.imgur.com/ZHzpvvE.png)](#)











# is-there

 [![Support me on Patreon][badge_patreon]][patreon] [![Buy me a book][badge_amazon]][amazon] [![PayPal][badge_paypal_donate]][paypal-donations] [![Ask me anything](https://img.shields.io/badge/ask%20me-anything-1abc9c.svg)](https://github.com/IonicaBizau/ama) [![Travis](https://img.shields.io/travis/IonicaBizau/node-is-there.svg)](https://travis-ci.org/IonicaBizau/node-is-there/) [![Version](https://img.shields.io/npm/v/is-there.svg)](https://www.npmjs.com/package/is-there) [![Downloads](https://img.shields.io/npm/dt/is-there.svg)](https://www.npmjs.com/package/is-there) [![Get help on Codementor](https://cdn.codementor.io/badges/get_help_github.svg)](https://www.codementor.io/johnnyb?utm_source=github&utm_medium=button&utm_term=johnnyb&utm_campaign=github)

<a href="https://www.buymeacoffee.com/H96WwChMy" target="_blank"><img src="https://www.buymeacoffee.com/assets/img/custom_images/yellow_img.png" alt="Buy Me A Coffee"></a>







> Check if a file or directory exists in a given path.






## Why? `fs.exists` already does the job!


Because `fs.exists` and `fs.existsSync` ~~will be~~ are deprecated and in some cases we still need them!

> `fs.exists()` is an anachronism and exists only for historical reasons. There should almost never be a reason to use it in your own code.
> In particular, checking if a file exists before opening it is an anti-pattern that leaves you vulnerable to race conditions: another process may remove the file between the calls to `fs.exists()` and `fs.open()`. Just open the file and handle the error when it's not there.
> **`fs.exists()` will be deprecated.**
> <sup>([Source](http://nodejs.org/api/fs.html#fs_fs_exists_path_callback), emphasis added)</sup>













## :cloud: Installation

```sh
# Using npm
npm install --save is-there

# Using yarn
yarn add is-there
```













## :clipboard: Example



```js
const IsThere = require("is-there");

// Sync
console.log(IsThere(`${__dirname}/contents/file`))
// => true
console.log(IsThere.directory(`${__dirname}/contents/dir`))

// Callback
IsThere.file(`${__dirname}/contents/not_found`, exists => {
    console.log(exists)
    // => false
})

// Promises
IsThere.promises.directory(`${__dirname}/contents/dir`).then(exists => {
    console.log(exists)
    // => true
}).catch(console.error)
```











## :question: Get Help

There are few ways to get help:



 1. Please [post questions on Stack Overflow](https://stackoverflow.com/questions/ask). You can open issues with questions, as long you add a link to your Stack Overflow question.
 2. For bug reports and feature requests, open issues. :bug:
 3. For direct and quick help, you can [use Codementor](https://www.codementor.io/johnnyb). :rocket:





## :memo: Documentation


### isThere

Checks if a file or directory exists on given path.
Use without the new keyword.

#### Params

- **String** `path`: The path to the file or directory.
- **Function** `callback`: The callback function called with a boolean value representing if the file or directory exists. If this parameter is not a
function, the function will run synchronously and return the value.

#### Return
- **isThere|Boolean** The `isThere` function if the `callback` parameter was provided, otherwise a boolean value indicating if the file/directory
exists or not.

### `isThere.directory(path, callback)`
Checks if the path exists and it is a directory.

#### Params

- **String** `path`: The path to the directory.
- **Function** `callback`: The callback function called with a boolean value representing if the directory exists. If this parameter is not a
function, the function will run synchronously and return the value.

#### Return
- **isThere|Boolean** The `isThere` function if the `callback` parameter was provided, otherwise a boolean value indicating if the directory exists or not.

### `isThere.file(path, callback)`
Check if the path exists and it is a file.

#### Params

- **String** `path`: The path to the file.
- **Function** `callback`: The callback function called with a boolean value representing if the file exists. If this parameter is not a
function, the function will run synchronously and return the value.

#### Return
- **isThere|Boolean** The `isThere` function if the `callback` parameter was provided, otherwise a boolean value indicating if the file exists or not.

### `isThere.promises()`
The promises interface.

It exports the following methods:

   - `isThere.promises.exists`
   - `isThere.promises.file`
   - `isThere.promises.directory`














## :yum: How to contribute
Have an idea? Found a bug? See [how to contribute][contributing].


## :sparkling_heart: Support my projects
I open-source almost everything I can, and I try to reply to everyone needing help using these projects. Obviously,
this takes time. You can integrate and use these projects in your applications *for free*! You can even change the source code and redistribute (even resell it).

However, if you get some profit from this or just want to encourage me to continue creating stuff, there are few ways you can do it:


 - Starring and sharing the projects you like :rocket:
 - [![Buy me a book][badge_amazon]][amazon]—I love books! I will remember you after years if you buy me one. :grin: :book:
 - [![PayPal][badge_paypal]][paypal-donations]—You can make one-time donations via PayPal. I'll probably buy a ~~coffee~~ tea. :tea:
 - [![Support me on Patreon][badge_patreon]][patreon]—Set up a recurring monthly donation and you will get interesting news about what I'm doing (things that I don't share with everyone).
 - **Bitcoin**—You can send me bitcoins at this address (or scanning the code below): `1P9BRsmazNQcuyTxEqveUsnf5CERdq35V6`

    ![](https://i.imgur.com/z6OQI95.png)


Thanks! :heart:
















## :dizzy: Where is this library used?
If you are using this library in one of your projects, add it in this list. :sparkles:

 - `typed-css-modules`
 - `node-sass-json-importer`
 - `ajs`
 - `be-goods`
 - `parent-search`
 - `sourcegate`
 - `fwatcher`
 - `ali-oss-extra`
 - `find-file-in-dirs`
 - `gulp-common-build-tasks`
 - `a-csv`
 - `bible.js`
 - `fie-toolkit-nuke`
 - `bloggify-actions`
 - `wml`
 - `git-stats`
 - `sp-load`
 - `engine-tools`
 - `hal-rc`
 - `engine-composition-crud`
 - `kaomojify`
 - `hg-plus`
 - `friendly-typed-css-modules`
 - `safe-file-write`
 - `no-one-left-behind`
 - `caipi`
 - `khoom`
 - `rc-ts-scripts`
 - `rc-ts-tools`
 - `react-scripts-pro`
 - `fie-toolkit-nuke-test`
 - `generator-arwen`
 - `caipi-cli`
 - `@density/node-sass-json-importer`
 - `@beisen/typed-css-modules`
 - `web-term`
 - `@onenexus/synergy-sass-importer`
 - `is-git-check`
 - `@raydeck/wml`
 - `@skbkontur/typed-css-modules`
 - `blah`
 - `gif-cli`
 - `kotori-webpack-plugin`
 - `minipod`
 - `bower-license-webpack-plugin`
 - `cecil`
 - `confetti-cli`
 - `firstant2gradle`
 - `generator-catena`
 - `generator-catena-angular-meteor-bootstrap`
 - `generator-leptir-angular-material`
 - `generator-leptir-angular-bootstrap`
 - `generator-leptir`
 - `generator-catena-angular-meteor-material`
 - `better-history`
 - `memories`
 - `matanza`
 - `minecraft-manager`
 - `bible`
 - `mage-vaulthelper-couchbase`
 - `gd-cli`
 - `envctl`
 - `obj2env-cli`
 - `fontify`
 - `low-cli`
 - `payname`
 - `f-watcher`
 - `bowerrc`
 - `singular_sake`
 - `uturi-caching`
 - `emartech-node-sass-json-importer`
 - `valkyrja`
 - `unity-asset-sync`
 - `engine-app`
 - `npm-interlink`
 - `panes`
 - `reindex-cli`
 - `generator-atomus`
 - `@dasilvacontin/clothes`
 - `jisc_build`
 - `le-serf`
 - `react-scripts-pro6`
 - `react-scripts-pro7`
 - `react-scripts-pro8`
 - `valkctl`
 - `@spernigotti/node-sass-json-importer`
 - `joomlascan`
 - `@miriamjs/wml`
 - `typed-css-interfaces`
 - `@mtsmfm/node-sass-json-importer`
 - `megadata`
 - `mage-module-shard`
 - `mage-vaulthelper-mysql`
 - `wlink`
 - `viur-ignite-css`
 - `viur-ignite-icons`
 - `viur-ignite-html`
 - `viur-ignite-js`
 - `my613-cli`
 - `tithe`
 - `tester-init`
 - `tilda-init`
 - `grunt-md5symlink`
 - `cdnjs-importer`
 - `@loomble/cli`
 - `mage-validator`
 - `wmls`
 - `@isysd/gpm`
 - `hakka-plugin-typed-css-modules`
 - `merry-plugin-typed-css-modules`
 - `ramda-cli`
 - `heroku-docker`
 - `heroku-container-tools`
 - `typed-css-modules-babel`
 - `@ceoimon/typed-css-modules`
 - `kaomojify-webpack-plugin`
 - `typed-css-modules-fork`
 - `watchwoman`
 - `watchwomen`
 - `@computerrock/node-sass-json-importer`
 - `mtsl`
 - `artstack-downloader`
 - `git-stats-importer`
 - `gpm`
 - `idea`
 - `image-to-ascii-cli`
 - `machine-ip`
 - `git-issues`











## :scroll: License

[MIT][license] © [Ionică Bizău][website]






[license]: /LICENSE
[website]: https://ionicabizau.net
[contributing]: /CONTRIBUTING.md
[docs]: /DOCUMENTATION.md
[badge_patreon]: https://ionicabizau.github.io/badges/patreon.svg
[badge_amazon]: https://ionicabizau.github.io/badges/amazon.svg
[badge_paypal]: https://ionicabizau.github.io/badges/paypal.svg
[badge_paypal_donate]: https://ionicabizau.github.io/badges/paypal_donate.svg
[patreon]: https://www.patreon.com/ionicabizau
[amazon]: http://amzn.eu/hRo9sIZ
[paypal-donations]: https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=RVXDDLKKLQRJW
