import HTMLElement from '../html-element/HTMLElement.js';
/**
 * HTMLSourceElement
 *
 * @see https://developer.mozilla.org/en-US/docs/Web/API/HTMLSourceElement
 */
export default class HTMLSourceElement extends HTMLElement {
    /**
     * Returns height.
     *
     * @returns Height.
     */
    get height(): number;
    /**
     * Sets height.
     *
     * @param value Height.
     */
    set height(value: number);
    /**
     * Returns width.
     *
     * @returns Width.
     */
    get width(): number;
    /**
     * Sets width.
     *
     * @param value Width.
     */
    set width(value: number);
    /**
     * Returns media.
     *
     * @returns Media.
     */
    get media(): string;
    /**
     * Sets media.
     *
     * @param value Media.
     */
    set media(value: string);
    /**
     * Returns sizes.
     *
     * @returns Sizes.
     */
    get sizes(): string;
    /**
     * Sets sizes.
     *
     * @param value Sizes.
     */
    set sizes(value: string);
    /**
     * Returns source.
     *
     * @returns Source.
     */
    get src(): string;
    /**
     * Sets source.
     *
     * @param src Source.
     */
    set src(src: string);
    /**
     * Returns source set.
     *
     * @returns Source set.
     */
    get srcset(): string;
    /**
     * Sets source set.
     *
     * @param value Source set.
     */
    set srcset(value: string);
    /**
     * Returns type.
     *
     * @returns Type.
     */
    get type(): string;
    /**
     * Sets type.
     *
     * @param type Type.
     */
    set type(type: string);
}
//# sourceMappingURL=HTMLSourceElement.d.ts.map