import { URLSearchParams } from 'url';
import * as PropertySymbol from './PropertySymbol.js';
import Browser from './browser/Browser.js';
import BrowserContext from './browser/BrowserContext.js';
import BrowserFrame from './browser/BrowserFrame.js';
import BrowserPage from './browser/BrowserPage.js';
import DetachedBrowser from './browser/detached-browser/DetachedBrowser.js';
import DetachedBrowserContext from './browser/detached-browser/DetachedBrowserContext.js';
import DetachedBrowserFrame from './browser/detached-browser/DetachedBrowserFrame.js';
import DetachedBrowserPage from './browser/detached-browser/DetachedBrowserPage.js';
import BrowserErrorCaptureEnum from './browser/enums/BrowserErrorCaptureEnum.js';
import BrowserNavigationCrossOriginPolicyEnum from './browser/enums/BrowserNavigationCrossOriginPolicyEnum.js';
import Clipboard from './clipboard/Clipboard.js';
import ClipboardItem from './clipboard/ClipboardItem.js';
import VirtualConsole from './console/VirtualConsole.js';
import VirtualConsolePrinter from './console/VirtualConsolePrinter.js';
import VirtualConsoleLogLevelEnum from './console/enums/VirtualConsoleLogLevelEnum.js';
import VirtualConsoleLogTypeEnum from './console/enums/VirtualConsoleLogTypeEnum.js';
import CSSRule from './css/CSSRule.js';
import CSSStyleSheet from './css/CSSStyleSheet.js';
import CSSStyleDeclaration from './css/declaration/CSSStyleDeclaration.js';
import CSSContainerRule from './css/rules/CSSContainerRule.js';
import CSSFontFaceRule from './css/rules/CSSFontFaceRule.js';
import CSSKeyframeRule from './css/rules/CSSKeyframeRule.js';
import CSSKeyframesRule from './css/rules/CSSKeyframesRule.js';
import CSSMediaRule from './css/rules/CSSMediaRule.js';
import CSSStyleRule from './css/rules/CSSStyleRule.js';
import CSSSupportsRule from './css/rules/CSSSupportsRule.js';
import CustomElementRegistry from './custom-element/CustomElementRegistry.js';
import DOMParser from './dom-parser/DOMParser.js';
import DataTransfer from './event/DataTransfer.js';
import DataTransferItem from './event/DataTransferItem.js';
import DataTransferItemList from './event/DataTransferItemList.js';
import Event from './event/Event.js';
import EventPhaseEnum from './event/EventPhaseEnum.js';
import EventTarget from './event/EventTarget.js';
import Touch from './event/Touch.js';
import UIEvent from './event/UIEvent.js';
import AnimationEvent from './event/events/AnimationEvent.js';
import ClipboardEvent from './event/events/ClipboardEvent.js';
import CustomEvent from './event/events/CustomEvent.js';
import ErrorEvent from './event/events/ErrorEvent.js';
import FocusEvent from './event/events/FocusEvent.js';
import HashChangeEvent from './event/events/HashChangeEvent.js';
import InputEvent from './event/events/InputEvent.js';
import KeyboardEvent from './event/events/KeyboardEvent.js';
import MediaQueryListEvent from './event/events/MediaQueryListEvent.js';
import MouseEvent from './event/events/MouseEvent.js';
import PointerEvent from './event/events/PointerEvent.js';
import ProgressEvent from './event/events/ProgressEvent.js';
import SubmitEvent from './event/events/SubmitEvent.js';
import TouchEvent from './event/events/TouchEvent.js';
import WheelEvent from './event/events/WheelEvent.js';
import DOMException from './exception/DOMException.js';
import AbortController from './fetch/AbortController.js';
import AbortSignal from './fetch/AbortSignal.js';
import Headers from './fetch/Headers.js';
import Request from './fetch/Request.js';
import Response from './fetch/Response.js';
import Blob from './file/Blob.js';
import File from './file/File.js';
import FileReader from './file/FileReader.js';
import FormData from './form-data/FormData.js';
import History from './history/History.js';
import IntersectionObserver from './intersection-observer/IntersectionObserver.js';
import IntersectionObserverEntry from './intersection-observer/IntersectionObserverEntry.js';
import Location from './location/Location.js';
import MutationObserver from './mutation-observer/MutationObserver.js';
import MutationRecord from './mutation-observer/MutationRecord.js';
import Attr from './nodes/attr/Attr.js';
import Comment from './nodes/comment/Comment.js';
import DocumentFragment from './nodes/document-fragment/DocumentFragment.js';
import DocumentType from './nodes/document-type/DocumentType.js';
import Document from './nodes/document/Document.js';
import DOMRect from './dom/DOMRect.js';
import DOMRectReadOnly from './dom/DOMRectReadOnly.js';
import Element from './nodes/element/Element.js';
import HTMLCollection from './nodes/element/HTMLCollection.js';
import HTMLAnchorElement from './nodes/html-anchor-element/HTMLAnchorElement.js';
import HTMLAreaElement from './nodes/html-area-element/HTMLAreaElement.js';
import HTMLAudioElement from './nodes/html-audio-element/HTMLAudioElement.js';
import HTMLBaseElement from './nodes/html-base-element/HTMLBaseElement.js';
import HTMLBodyElement from './nodes/html-body-element/HTMLBodyElement.js';
import HTMLBRElement from './nodes/html-br-element/HTMLBRElement.js';
import HTMLButtonElement from './nodes/html-button-element/HTMLButtonElement.js';
import HTMLCanvasElement from './nodes/html-canvas-element/HTMLCanvasElement.js';
import HTMLDListElement from './nodes/html-d-list-element/HTMLDListElement.js';
import HTMLDataElement from './nodes/html-data-element/HTMLDataElement.js';
import HTMLDataListElement from './nodes/html-data-list-element/HTMLDataListElement.js';
import HTMLDetailsElement from './nodes/html-details-element/HTMLDetailsElement.js';
import HTMLDialogElement from './nodes/html-dialog-element/HTMLDialogElement.js';
import HTMLDivElement from './nodes/html-div-element/HTMLDivElement.js';
import HTMLDocument from './nodes/html-document/HTMLDocument.js';
import HTMLElement from './nodes/html-element/HTMLElement.js';
import HTMLEmbedElement from './nodes/html-embed-element/HTMLEmbedElement.js';
import HTMLFieldSetElement from './nodes/html-field-set-element/HTMLFieldSetElement.js';
import HTMLFormControlsCollection from './nodes/html-form-element/HTMLFormControlsCollection.js';
import HTMLFormElement from './nodes/html-form-element/HTMLFormElement.js';
import HTMLHeadElement from './nodes/html-head-element/HTMLHeadElement.js';
import HTMLHeadingElement from './nodes/html-heading-element/HTMLHeadingElement.js';
import HTMLHRElement from './nodes/html-hr-element/HTMLHRElement.js';
import HTMLHtmlElement from './nodes/html-html-element/HTMLHtmlElement.js';
import HTMLIFrameElement from './nodes/html-iframe-element/HTMLIFrameElement.js';
import HTMLImageElement from './nodes/html-image-element/HTMLImageElement.js';
import Image from './nodes/html-image-element/Image.js';
import FileList from './nodes/html-input-element/FileList.js';
import HTMLInputElement from './nodes/html-input-element/HTMLInputElement.js';
import HTMLLabelElement from './nodes/html-label-element/HTMLLabelElement.js';
import HTMLLegendElement from './nodes/html-legend-element/HTMLLegendElement.js';
import HTMLLIElement from './nodes/html-li-element/HTMLLIElement.js';
import HTMLLinkElement from './nodes/html-link-element/HTMLLinkElement.js';
import HTMLMapElement from './nodes/html-map-element/HTMLMapElement.js';
import HTMLMediaElement from './nodes/html-media-element/HTMLMediaElement.js';
import MediaStream from './nodes/html-media-element/MediaStream.js';
import MediaStreamTrack from './nodes/html-media-element/MediaStreamTrack.js';
import RemotePlayback from './nodes/html-media-element/RemotePlayback.js';
import TextTrack from './nodes/html-media-element/TextTrack.js';
import TextTrackCue from './nodes/html-media-element/TextTrackCue.js';
import TextTrackCueList from './nodes/html-media-element/TextTrackCueList.js';
import TextTrackList from './nodes/html-media-element/TextTrackList.js';
import VTTCue from './nodes/html-media-element/VTTCue.js';
import HTMLMenuElement from './nodes/html-menu-element/HTMLMenuElement.js';
import HTMLMetaElement from './nodes/html-meta-element/HTMLMetaElement.js';
import HTMLMeterElement from './nodes/html-meter-element/HTMLMeterElement.js';
import HTMLModElement from './nodes/html-mod-element/HTMLModElement.js';
import HTMLOListElement from './nodes/html-o-list-element/HTMLOListElement.js';
import HTMLObjectElement from './nodes/html-object-element/HTMLObjectElement.js';
import HTMLOptGroupElement from './nodes/html-opt-group-element/HTMLOptGroupElement.js';
import HTMLOptionElement from './nodes/html-option-element/HTMLOptionElement.js';
import HTMLOutputElement from './nodes/html-output-element/HTMLOutputElement.js';
import HTMLParagraphElement from './nodes/html-paragraph-element/HTMLParagraphElement.js';
import HTMLParamElement from './nodes/html-param-element/HTMLParamElement.js';
import HTMLPictureElement from './nodes/html-picture-element/HTMLPictureElement.js';
import HTMLPreElement from './nodes/html-pre-element/HTMLPreElement.js';
import HTMLProgressElement from './nodes/html-progress-element/HTMLProgressElement.js';
import HTMLQuoteElement from './nodes/html-quote-element/HTMLQuoteElement.js';
import HTMLScriptElement from './nodes/html-script-element/HTMLScriptElement.js';
import HTMLSelectElement from './nodes/html-select-element/HTMLSelectElement.js';
import HTMLSlotElement from './nodes/html-slot-element/HTMLSlotElement.js';
import HTMLSourceElement from './nodes/html-source-element/HTMLSourceElement.js';
import HTMLSpanElement from './nodes/html-span-element/HTMLSpanElement.js';
import HTMLStyleElement from './nodes/html-style-element/HTMLStyleElement.js';
import HTMLTableCaptionElement from './nodes/html-table-caption-element/HTMLTableCaptionElement.js';
import HTMLTableCellElement from './nodes/html-table-cell-element/HTMLTableCellElement.js';
import HTMLTableColElement from './nodes/html-table-col-element/HTMLTableColElement.js';
import HTMLTableElement from './nodes/html-table-element/HTMLTableElement.js';
import HTMLTableRowElement from './nodes/html-table-row-element/HTMLTableRowElement.js';
import HTMLTableSectionElement from './nodes/html-table-section-element/HTMLTableSectionElement.js';
import HTMLTemplateElement from './nodes/html-template-element/HTMLTemplateElement.js';
import HTMLTextAreaElement from './nodes/html-text-area-element/HTMLTextAreaElement.js';
import HTMLTimeElement from './nodes/html-time-element/HTMLTimeElement.js';
import HTMLTitleElement from './nodes/html-title-element/HTMLTitleElement.js';
import HTMLTrackElement from './nodes/html-track-element/HTMLTrackElement.js';
import HTMLUListElement from './nodes/html-u-list-element/HTMLUListElement.js';
import HTMLUnknownElement from './nodes/html-unknown-element/HTMLUnknownElement.js';
import HTMLVideoElement from './nodes/html-video-element/HTMLVideoElement.js';
import Node from './nodes/node/Node.js';
import ProcessingInstruction from './nodes/processing-instruction/ProcessingInstruction.js';
import ShadowRoot from './nodes/shadow-root/ShadowRoot.js';
import SVGElement from './nodes/svg-element/SVGElement.js';
import SVGGraphicsElement from './nodes/svg-graphics-element/SVGGraphicsElement.js';
import SVGSVGElement from './nodes/svg-svg-element/SVGSVGElement.js';
import Text from './nodes/text/Text.js';
import XMLDocument from './nodes/xml-document/XMLDocument.js';
import PermissionStatus from './permissions/PermissionStatus.js';
import Permissions from './permissions/Permissions.js';
import Range from './range/Range.js';
import ResizeObserver from './resize-observer/ResizeObserver.js';
import Screen from './screen/Screen.js';
import Selection from './selection/Selection.js';
import Storage from './storage/Storage.js';
import NodeFilter from './tree-walker/NodeFilter.js';
import NodeIterator from './tree-walker/NodeIterator.js';
import TreeWalker from './tree-walker/TreeWalker.js';
import URL from './url/URL.js';
import BrowserWindow from './window/BrowserWindow.js';
import DetachedWindowAPI from './window/DetachedWindowAPI.js';
import GlobalWindow from './window/GlobalWindow.js';
import Window from './window/Window.js';
import XMLParser from './xml-parser/XMLParser.js';
import XMLSerializer from './xml-serializer/XMLSerializer.js';
import type IBrowser from './browser/types/IBrowser.js';
import type IBrowserContext from './browser/types/IBrowserContext.js';
import type IBrowserFrame from './browser/types/IBrowserFrame.js';
import type IBrowserPage from './browser/types/IBrowserPage.js';
import type IBrowserSettings from './browser/types/IBrowserSettings.js';
import type IOptionalBrowserSettings from './browser/types/IOptionalBrowserSettings.js';
import type IEventInit from './event/IEventInit.js';
import type TEventListener from './event/TEventListener.js';
import type ITouchInit from './event/ITouchInit.js';
import type IUIEventInit from './event/IUIEventInit.js';
import type IAnimationEventInit from './event/events/IAnimationEventInit.js';
import type IClipboardEventInit from './event/events/IClipboardEventInit.js';
import type ICustomEventInit from './event/events/ICustomEventInit.js';
import type IErrorEventInit from './event/events/IErrorEventInit.js';
import type IFocusEventInit from './event/events/IFocusEventInit.js';
import type IHashChangeEventInit from './event/events/IHashChangeEventInit.js';
import type IInputEventInit from './event/events/IInputEventInit.js';
import type IKeyboardEventInit from './event/events/IKeyboardEventInit.js';
import type IMediaQueryListInit from './event/events/IMediaQueryListInit.js';
import type IMouseEventInit from './event/events/IMouseEventInit.js';
import type IProgressEventInit from './event/events/IProgressEventInit.js';
import type ISubmitEventInit from './event/events/ISubmitEventInit.js';
import type ITouchEventInit from './event/events/ITouchEventInit.js';
import type IWheelEventInit from './event/events/IWheelEventInit.js';
export type { IAnimationEventInit, IBrowser, IBrowserContext, IBrowserFrame, IBrowserPage, IBrowserSettings, IClipboardEventInit, ICustomEventInit, IErrorEventInit, IEventInit, TEventListener, IFocusEventInit, IHashChangeEventInit, IInputEventInit, IKeyboardEventInit, IMediaQueryListInit, IMouseEventInit, IOptionalBrowserSettings, IProgressEventInit, ISubmitEventInit, ITouchEventInit, ITouchInit, IUIEventInit, IWheelEventInit };
export { AbortController, AbortSignal, AnimationEvent, Attr, Blob, Browser, BrowserContext, BrowserErrorCaptureEnum, BrowserFrame, BrowserNavigationCrossOriginPolicyEnum, BrowserPage, BrowserWindow, Clipboard, ClipboardEvent, ClipboardItem, Comment, CSSContainerRule, CSSFontFaceRule, CSSKeyframeRule, CSSKeyframesRule, CSSMediaRule, CSSRule, CSSStyleDeclaration, CSSStyleRule, CSSStyleSheet, CSSSupportsRule, CustomElementRegistry, CustomEvent, DataTransfer, DataTransferItem, DataTransferItemList, DetachedBrowser, DetachedBrowserContext, DetachedBrowserFrame, DetachedBrowserPage, DetachedWindowAPI, Document, DocumentFragment, DocumentType, DOMException, DOMParser, DOMRect, DOMRectReadOnly, Element, ErrorEvent, Event, EventPhaseEnum, EventTarget, File, FileList, FileReader, FocusEvent, FormData, GlobalWindow, HashChangeEvent, Headers, History, HTMLAnchorElement, HTMLAreaElement, HTMLAudioElement, HTMLBaseElement, HTMLBodyElement, HTMLBRElement, HTMLButtonElement, HTMLCanvasElement, HTMLCollection, HTMLDataElement, HTMLDataListElement, HTMLDetailsElement, HTMLDialogElement, HTMLDivElement, HTMLDListElement, HTMLDocument, HTMLElement, HTMLEmbedElement, HTMLFieldSetElement, HTMLFormControlsCollection, HTMLFormElement, HTMLHeadElement, HTMLHeadingElement, HTMLHRElement, HTMLHtmlElement, HTMLIFrameElement, HTMLImageElement, HTMLInputElement, HTMLLabelElement, HTMLLegendElement, HTMLLIElement, HTMLLinkElement, HTMLMapElement, HTMLMediaElement, HTMLMenuElement, HTMLMetaElement, HTMLMeterElement, HTMLModElement, HTMLObjectElement, HTMLOListElement, HTMLOptGroupElement, HTMLOptionElement, HTMLOutputElement, HTMLParagraphElement, HTMLParamElement, HTMLPictureElement, HTMLPreElement, HTMLProgressElement, HTMLQuoteElement, HTMLScriptElement, HTMLSelectElement, HTMLSlotElement, HTMLSourceElement, HTMLSpanElement, HTMLStyleElement, HTMLTableCaptionElement, HTMLTableCellElement, HTMLTableColElement, HTMLTableElement, HTMLTableRowElement, HTMLTableSectionElement, HTMLTemplateElement, HTMLTextAreaElement, HTMLTimeElement, HTMLTitleElement, HTMLTrackElement, HTMLUListElement, HTMLUnknownElement, HTMLVideoElement, Image, InputEvent, IntersectionObserver, IntersectionObserverEntry, KeyboardEvent, Location, MediaQueryListEvent, MediaStream, MediaStreamTrack, MouseEvent, MutationObserver, MutationRecord, Node, NodeFilter, NodeIterator, Permissions, PermissionStatus, PointerEvent, ProcessingInstruction, ProgressEvent, PropertySymbol, Range, RemotePlayback, Request, ResizeObserver, Response, Screen, Selection, ShadowRoot, Storage, SubmitEvent, SVGElement, SVGGraphicsElement, SVGSVGElement, Text, TextTrack, TextTrackCue, TextTrackCueList, TextTrackList, Touch, TouchEvent, TreeWalker, UIEvent, URL, URLSearchParams, VirtualConsole, VirtualConsoleLogLevelEnum, VirtualConsoleLogTypeEnum, VirtualConsolePrinter, VTTCue, WheelEvent, Window, XMLDocument, XMLParser, XMLSerializer };
//# sourceMappingURL=index.d.ts.map