'use strict'
Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' })
let validateGroupsConfiguration = (
  groups,
  allowedPredefinedGroups,
  allowedCustomGroups,
) => {
  let allowedGroupsSet = /* @__PURE__ */ new Set([
    ...allowedPredefinedGroups,
    ...allowedCustomGroups,
  ])
  let invalidGroups = []
  let isPreviousElementNewlinesBetween = false
  for (let groupElement of groups) {
    if (typeof groupElement === 'object' && 'newlinesBetween' in groupElement) {
      if (isPreviousElementNewlinesBetween) {
        throw new Error("Consecutive 'newlinesBetween' objects are not allowed")
      }
      isPreviousElementNewlinesBetween = true
    } else {
      isPreviousElementNewlinesBetween = false
      let groupElements = Array.isArray(groupElement)
        ? groupElement
        : [groupElement]
      for (let group of groupElements) {
        if (!allowedGroupsSet.has(group)) {
          invalidGroups.push(group)
        }
      }
    }
  }
  if (invalidGroups.length) {
    throw new Error(`Invalid group(s): ${invalidGroups.join(', ')}`)
  }
  validateNoDuplicatedGroups(groups)
}
let validateNoDuplicatedGroups = groups => {
  let flattenGroups = groups.flat()
  let seenGroups = /* @__PURE__ */ new Set()
  let duplicatedGroups = /* @__PURE__ */ new Set()
  for (let group of flattenGroups) {
    if (typeof group === 'object' && 'newlinesBetween' in group) {
      continue
    }
    if (seenGroups.has(group)) {
      duplicatedGroups.add(group)
    } else {
      seenGroups.add(group)
    }
  }
  if (duplicatedGroups.size > 0) {
    throw new Error(`Duplicated group(s): ${[...duplicatedGroups].join(', ')}`)
  }
}
exports.validateGroupsConfiguration = validateGroupsConfiguration
exports.validateNoDuplicatedGroups = validateNoDuplicatedGroups
