'use strict'
Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' })
const types = require('@typescript-eslint/types')
const getEslintDisabledRules = require('./get-eslint-disabled-rules.js')
const matches = require('./matches.js')
let isPartitionComment = ({ partitionByComment, comment }) => {
  if (
    getEslintDisabledRules.getEslintDisabledRules(comment.value) ||
    !partitionByComment
  ) {
    return false
  }
  let trimmedComment = comment.value.trim()
  if (
    Array.isArray(partitionByComment) ||
    typeof partitionByComment === 'boolean' ||
    typeof partitionByComment === 'string'
  ) {
    return isTrimmedCommentPartitionComment({
      partitionByComment,
      trimmedComment,
    })
  }
  let relevantPartitionByComment =
    comment.type === types.AST_TOKEN_TYPES.Block
      ? partitionByComment.block
      : partitionByComment.line
  return (
    // eslint-disable-next-line no-undefined
    relevantPartitionByComment !== void 0 &&
    isTrimmedCommentPartitionComment({
      partitionByComment: relevantPartitionByComment,
      trimmedComment,
    })
  )
}
let isTrimmedCommentPartitionComment = ({
  partitionByComment,
  trimmedComment,
}) => {
  if (typeof partitionByComment === 'boolean') {
    return partitionByComment
  }
  if (typeof partitionByComment === 'string') {
    return matches.matches(trimmedComment.trim(), partitionByComment)
  }
  return partitionByComment.some(pattern =>
    matches.matches(trimmedComment.trim(), pattern),
  )
}
exports.isPartitionComment = isPartitionComment
