'use strict'
Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' })
let getCustomGroupsCompareOptions = (options, groupNumber) => {
  if (!Array.isArray(options.customGroups)) {
    return options
  }
  let group = options.groups[groupNumber]
  let customGroup =
    typeof group === 'string'
      ? options.customGroups.find(
          currentGroup => group === currentGroup.groupName,
        )
      : null
  if ((customGroup == null ? void 0 : customGroup.type) === 'unsorted') {
    return null
  }
  return {
    order:
      customGroup && 'order' in customGroup && customGroup.order
        ? customGroup.order
        : options.order,
    specialCharacters: options.specialCharacters,
    type: (customGroup == null ? void 0 : customGroup.type) ?? options.type,
    ignoreCase: options.ignoreCase,
    alphabet: options.alphabet,
    locales: options.locales,
  }
}
exports.getCustomGroupsCompareOptions = getCustomGroupsCompareOptions
