'use strict'
const sortArrayIncludes = require('./sort-array-includes.js')
const createEslintRule = require('../utils/create-eslint-rule.js')
const sortSets = createEslintRule.createEslintRule({
  create: context => ({
    NewExpression: node => {
      var _a, _b
      if (
        node.callee.type === 'Identifier' &&
        node.callee.name === 'Set' &&
        node.arguments.length &&
        (((_a = node.arguments[0]) == null ? void 0 : _a.type) ===
          'ArrayExpression' ||
          (((_b = node.arguments[0]) == null ? void 0 : _b.type) ===
            'NewExpression' &&
            'name' in node.arguments[0].callee &&
            node.arguments[0].callee.name === 'Array'))
      ) {
        let elements =
          node.arguments[0].type === 'ArrayExpression'
            ? node.arguments[0].elements
            : node.arguments[0].arguments
        sortArrayIncludes.sortArray({
          availableMessageIds: {
            unexpectedGroupOrder: 'unexpectedSetsGroupOrder',
            unexpectedOrder: 'unexpectedSetsOrder',
          },
          elements,
          context,
        })
      }
    },
  }),
  meta: {
    messages: {
      unexpectedSetsGroupOrder:
        'Expected "{{right}}" ({{rightGroup}}) to come before "{{left}}" ({{leftGroup}}).',
      unexpectedSetsOrder: 'Expected "{{right}}" to come before "{{left}}".',
    },
    docs: {
      url: 'https://perfectionist.dev/rules/sort-sets',
      description: 'Enforce sorted sets.',
      recommended: true,
    },
    schema: sortArrayIncludes.jsonSchema,
    type: 'suggestion',
    fixable: 'code',
  },
  defaultOptions: [sortArrayIncludes.defaultOptions],
  name: 'sort-sets',
})
module.exports = sortSets
