'use strict'
const sortObjectTypes = require('./sort-object-types.js')
const createEslintRule = require('../utils/create-eslint-rule.js')
let defaultOptions = {
  partitionByComment: false,
  partitionByNewLine: false,
  newlinesBetween: 'ignore',
  specialCharacters: 'keep',
  useConfigurationIf: {},
  type: 'alphabetical',
  groupKind: 'mixed',
  ignorePattern: [],
  ignoreCase: true,
  customGroups: {},
  locales: 'en-US',
  alphabet: '',
  order: 'asc',
  groups: [],
}
const sortInterfaces = createEslintRule.createEslintRule({
  meta: {
    messages: {
      unexpectedInterfacePropertiesGroupOrder:
        'Expected "{{right}}" ({{rightGroup}}) to come before "{{left}}" ({{leftGroup}}).',
      missedSpacingBetweenInterfaceMembers:
        'Missed spacing between "{{left}}" and "{{right}}" interfaces.',
      extraSpacingBetweenInterfaceMembers:
        'Extra spacing between "{{left}}" and "{{right}}" interfaces.',
      unexpectedInterfacePropertiesOrder:
        'Expected "{{right}}" to come before "{{left}}".',
    },
    docs: {
      url: 'https://perfectionist.dev/rules/sort-interfaces',
      description: 'Enforce sorted interface properties.',
      recommended: true,
    },
    schema: sortObjectTypes.jsonSchema,
    type: 'suggestion',
    fixable: 'code',
  },
  create: context => ({
    TSInterfaceDeclaration: node =>
      sortObjectTypes.sortObjectTypeElements({
        availableMessageIds: {
          missedSpacingBetweenMembers: 'missedSpacingBetweenInterfaceMembers',
          extraSpacingBetweenMembers: 'extraSpacingBetweenInterfaceMembers',
          unexpectedGroupOrder: 'unexpectedInterfacePropertiesGroupOrder',
          unexpectedOrder: 'unexpectedInterfacePropertiesOrder',
        },
        parentNodeName: node.id.name,
        elements: node.body.body,
        context,
      }),
  }),
  defaultOptions: [defaultOptions],
  name: 'sort-interfaces',
})
module.exports = sortInterfaces
