'use strict'
Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' })
const types = require('@typescript-eslint/types')
let getDecoratorName = decorator => {
  switch (decorator.expression.type) {
    case types.AST_NODE_TYPES.CallExpression:
      if (
        decorator.expression.callee.type !== types.AST_NODE_TYPES.Identifier
      ) {
        throw new Error(
          "Unexpected decorator expression's callee type. Please 'report this issue here: https://github.com/azat-io/eslint-plugin-perfectionist/issues",
        )
      }
      return decorator.expression.callee.name
    case types.AST_NODE_TYPES.Identifier:
      return decorator.expression.name
    default:
      throw new Error(
        'Unexpected decorator expression type. Please report this issue here: https://github.com/azat-io/eslint-plugin-perfectionist/issues',
      )
  }
}
exports.getDecoratorName = getDecoratorName
