"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.initVarsFromEnv = exports.str = exports.setArguments = exports.initLogging = exports.loadContext = void 0;
const yargs_1 = __importDefault(require("yargs"));
const path_1 = require("path");
const helpers_1 = require("yargs/helpers");
const project_1 = require("./project");
const project_2 = require("@trapezedev/project");
async function loadContext(projectRootPath, androidProject, iosProject) {
    const rootDir = process.cwd();
    const args = (0, yargs_1.default)((0, helpers_1.hideBin)(process.argv));
    const argv = args.argv;
    let project;
    try {
        project = await (0, project_1.loadProject)(argv, projectRootPath !== null && projectRootPath !== void 0 ? projectRootPath : argv.projectRoot, androidProject !== null && androidProject !== void 0 ? androidProject : argv.androidProject, iosProject !== null && iosProject !== void 0 ? iosProject : argv.iosProject);
    }
    catch (e) {
        throw new Error(`Unable to load Capacitor project: ${e.message}: ${e.stack}`);
    }
    return {
        project,
        args: argv,
        vars: {},
        projectRootPath,
        // Important for resolving custom prettier plugin
        nodePackageRoot: (0, path_1.join)(__dirname, '../../'),
        rootDir,
    };
}
exports.loadContext = loadContext;
function initLogging(args) {
    process.env.VERBOSE = process.env.VERBOSE || '' + !!args.find(a => a === '--verbose');
}
exports.initLogging = initLogging;
function setArguments(ctx, args) {
    ctx.args = args;
}
exports.setArguments = setArguments;
// Given a variable of the form $VARIABLE, resolve the
// actual value from the environment
function str(ctx, s) {
    // Check for situations where our string exactly matches a var and
    // then use that as a special case to either interpolate the string
    // or return the variables value (to support JSON-values);
    const foundVar = ctx.vars[s.slice(1)];
    if (foundVar) {
        if (typeof foundVar.value === 'string') {
            return s.replace(/\$[^\(\{\[][\w.]+/g, foundVar.value);
        }
        return foundVar.value;
    }
    // Otherwise do a string interpolation of each value
    // Replace any variables in the string, ignoring
    // ones of the type $(blah) which are handled by the platform (i.e. iOS)
    s = s.replace(/\$[^\(\{\[][\w]+/g, (m) => {
        const foundVar = ctx.vars[m.slice(1)];
        if (foundVar && typeof foundVar.value === 'string') {
            return foundVar.value || '';
        }
        else {
            // We're in a string so the only thing to do at this point is
            // serialize any JSON values
            return foundVar ? JSON.stringify(foundVar.value) : '';
        }
    });
    return s;
}
exports.str = str;
// Given a list of vars from our configuration, initialize
// any that are already found in the process env
function initVarsFromEnv(ctx, vars) {
    if (!vars) {
        return;
    }
    for (const v in vars) {
        let existing = process.env[v];
        const entry = vars[v];
        try {
            if (entry.type && typeof existing !== 'undefined') {
                ctx.vars[v] = {
                    value: getVariableFromType(entry, existing)
                };
                continue;
            }
            existing = existing && JSON.parse(existing);
            if (typeof existing !== 'undefined') {
                project_2.Logger.v('env', 'loadEnvVars', `Loaded env var ${v} as JSON value`);
            }
        }
        catch (e) {
            project_2.Logger.v('env', 'loadEnvVars', `Loaded env var ${v} as string`);
        }
        finally {
            if (typeof ctx.vars[v] === 'undefined' && typeof existing !== 'undefined') {
                ctx.vars[v] = {
                    value: existing,
                };
            }
        }
    }
}
exports.initVarsFromEnv = initVarsFromEnv;
function getVariableFromType(entry, existing) {
    switch (entry.type) {
        case "array" /* VariableType.Array */:
        case "object" /* VariableType.Object */:
            return JSON.parse(existing);
        case "string" /* VariableType.String */:
            return existing;
        case "number" /* VariableType.Number */:
            return parseInt(existing, 10);
    }
}
//# sourceMappingURL=ctx.js.map