"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.resolveNode = exports.requireTS = void 0;
const utils_fs_1 = require("@ionic/utils-fs");
const path_1 = require("path");
const typescript_1 = __importDefault(require("typescript"));
function requireTS(p) {
    const id = (0, path_1.resolve)(p);
    delete require.cache[id];
    require.extensions['.ts'] = (module, fileName) => {
        var _a;
        let sourceText = (0, utils_fs_1.readFileSync)(fileName, 'utf8');
        if (fileName.endsWith('.ts')) {
            const tsResults = typescript_1.default.transpileModule(sourceText, {
                fileName,
                compilerOptions: {
                    module: typescript_1.default.ModuleKind.CommonJS,
                    moduleResolution: typescript_1.default.ModuleResolutionKind.NodeJs,
                    esModuleInterop: true,
                    strict: true,
                    target: typescript_1.default.ScriptTarget.ES2017,
                },
                reportDiagnostics: true,
            });
            sourceText = tsResults.outputText;
        }
        else {
            // quick hack to turn a modern es module
            // into and old school commonjs module
            sourceText = sourceText.replace(/export\s+\w+\s+(\w+)/gm, 'exports.$1');
        }
        (_a = module._compile) === null || _a === void 0 ? void 0 : _a.call(module, sourceText, fileName);
    };
    const m = require(id); // eslint-disable-line @typescript-eslint/no-var-requires
    delete require.extensions['.ts'];
    return m;
}
exports.requireTS = requireTS;
;
function resolveNode(root, ...pathSegments) {
    try {
        return require.resolve(pathSegments.join('/'), { paths: [root] });
    }
    catch (e) {
        return null;
    }
}
exports.resolveNode = resolveNode;
//# sourceMappingURL=node.js.map