// src/processors/css.ts
import { TaggedTemplateProcessor } from "@wyw-in-js/processor-utils";
var CssProcessor = class extends TaggedTemplateProcessor {
  get asSelector() {
    return this.className;
  }
  get value() {
    return this.astService.stringLiteral(this.className);
  }
  // eslint-disable-next-line class-methods-use-this
  addInterpolation(node, precedingCss, source) {
    throw new Error(
      `css tag cannot handle '${source}' as an interpolated value`
    );
  }
  doEvaltimeReplacement() {
    this.replacer(this.value, false);
  }
  doRuntimeReplacement() {
    this.replacer(this.astService.stringLiteral(this.className), false);
  }
  extractRules(valueCache, cssText, loc) {
    const rules = {};
    const selector = `.${this.className}`;
    rules[selector] = {
      cssText,
      className: this.className,
      displayName: this.displayName,
      start: loc?.start ?? null
    };
    return rules;
  }
};
export {
  CssProcessor as default
};
//# sourceMappingURL=css.mjs.map