import { matchPath as reactRouterMatchPath } from 'react-router';
interface MatchPathOptions {
    /**
     * The pathname to match against.
     */
    pathname: string;
    /**
     * The props to match against, they are identical to the matching props `Route` accepts.
     */
    componentProps: {
        path?: string;
        from?: string;
        component?: any;
        exact?: boolean;
    };
}
/**
 * @see https://v5.reactrouter.com/web/api/matchPath
 */
export declare const matchPath: ({ pathname, componentProps, }: MatchPathOptions) => false | ReturnType<typeof reactRouterMatchPath>;
export {};
