/**
 * @typedef {import('mdast').Nodes} Nodes
 * @typedef {import('mdast').Paragraph} Paragraph
 *
 * @typedef {import('mdast-util-from-markdown').CompileContext} CompileContext
 * @typedef {import('mdast-util-from-markdown').Extension} FromMarkdownExtension
 * @typedef {import('mdast-util-from-markdown').Handle} FromMarkdownHandle
 * @typedef {import('mdast-util-from-markdown').Token} Token
 *
 * @typedef {import('mdast-util-to-markdown').ConstructName} ConstructName
 * @typedef {import('mdast-util-to-markdown').State} State
 *
 * @typedef {import('../index.js').Details} Details
 * @typedef {import('../index.js').Summary} Summary
 */
/**
 * Create an extension for `mdast-util-from-markdown` to enable spoilers in
 * markdown.
 *
 * @returns {FromMarkdownExtension}
 *   Extension for `mdast-util-from-markdown` to enable spoilers.
 */
export function spoilerFromMarkdown(): FromMarkdownExtension
export type Nodes = import('mdast').Nodes
export type Paragraph = import('mdast').Paragraph
export type CompileContext = import('mdast-util-from-markdown').CompileContext
export type FromMarkdownExtension = import('mdast-util-from-markdown').Extension
export type FromMarkdownHandle = import('mdast-util-from-markdown').Handle
export type Token = import('mdast-util-from-markdown').Token
export type ConstructName = import('mdast-util-to-markdown').ConstructName
export type State = import('mdast-util-to-markdown').State
export type Details = import('../index.js').Details
export type Summary = import('../index.js').Summary
