/**
 * @param {Readonly<Element>} node
 *   hast element to inspect.
 * @param {Properties | undefined} [properties]
 *   Properties to use, normally taken from `node`, but can be changed.
 * @returns {Options}
 *   Options.
 */
export function findSelectedOptions(node: Readonly<Element>, properties?: Properties | undefined): Options;
export type Element = import('hast').Element;
export type Properties = import('hast').Properties;
export type State = import('../state.js').State;
/**
 * Option, where the item at `0` is the label, the item at `1` the value.
 */
export type Option = [string, Value];
/**
 * List of options.
 */
export type Options = Array<[string, Value]>;
/**
 * `value` field of option.
 */
export type Value = string | undefined;
