/**
 * Transform hast to mdast.
 *
 * @param {Readonly<Nodes>} tree
 *   hast tree to transform.
 * @param {Readonly<Options> | null | undefined} [options]
 *   Configuration (optional).
 * @returns {MdastNodes}
 *   mdast tree.
 */
export function toMdast(tree: Readonly<Nodes>, options?: Readonly<Options> | null | undefined): MdastNodes;
export type Nodes = import('hast').Nodes;
export type MdastNodes = import('mdast').Nodes;
export type MdastRootContent = import('mdast').RootContent;
export type Options = import('./state.js').Options;
