/**
 * @param {State} state
 *   State.
 * @param {Readonly<Element>} node
 *   hast element to transform.
 * @returns {Table | Text}
 *   mdast node.
 */
export function table(state: State, node: Readonly<Element>): Table | Text;
export type Element = import('hast').Element;
export type AlignType = import('mdast').AlignType;
export type RowContent = import('mdast').RowContent;
export type Table = import('mdast').Table;
export type TableContent = import('mdast').TableContent;
export type Text = import('mdast').Text;
export type State = import('../state.js').State;
/**
 * Inferred info on a table.
 */
export type Info = {
    /**
     * Alignment.
     */
    align: Array<AlignType>;
    /**
     * Whether a `thead` is missing.
     */
    headless: boolean;
};
