import DocumentFragment from '../document-fragment/DocumentFragment.js';
import * as PropertySymbol from '../../PropertySymbol.js';
import XMLParser from '../../xml-parser/XMLParser.js';
import XMLSerializer from '../../xml-serializer/XMLSerializer.js';
/**
 * ShadowRoot.
 */
export default class ShadowRoot extends DocumentFragment {
    // Events
    onslotchange = null;
    // Internal properties
    [PropertySymbol.adoptedStyleSheets] = [];
    [PropertySymbol.mode] = 'open';
    [PropertySymbol.host] = null;
    [PropertySymbol.clonable] = false;
    [PropertySymbol.delegatesFocus] = false;
    [PropertySymbol.serializable] = false;
    [PropertySymbol.slotAssignment] = 'named';
    /**
     * Returns mode.
     *
     * @returns Mode.
     */
    get mode() {
        return this[PropertySymbol.mode];
    }
    /**
     * Returns host.
     *
     * @returns Host.
     */
    get host() {
        return this[PropertySymbol.host];
    }
    /**
     * Returns clonable.
     *
     * @returns Clonable.
     */
    get clonable() {
        return this[PropertySymbol.clonable];
    }
    /**
     * Returns delegates focus.
     *
     * @returns Delegates focus.
     */
    get delegatesFocus() {
        // TODO: Implement delegates focus
        return this[PropertySymbol.delegatesFocus];
    }
    /**
     * Returns serializable.
     *
     * @returns Serializable.
     */
    get serializable() {
        return this[PropertySymbol.serializable];
    }
    /**
     * Returns slot assignment.
     *
     * @returns Slot assignment.
     */
    get slotAssignment() {
        return this[PropertySymbol.slotAssignment];
    }
    /**
     * The element that's currently in full screen mode for this shadow tree.
     *
     * @returns Fullscreen element.
     */
    get fullscreenElement() {
        // TODO: Implement fullscreen element
        return null;
    }
    /**
     * Returns the Element within the shadow tree that is currently being presented in picture-in-picture mode.
     *
     * @returns Picture-in-picture element.
     */
    get pictureInPictureElement() {
        // TODO: Implement picture-in-picture element
        return null;
    }
    /**
     * Returns the Element set as the target for mouse events while the pointer is locked. null if lock is pending, pointer is unlocked, or if the target is in another tree.
     *
     * @returns Pointer lock element.
     */
    get pointerLockElement() {
        // TODO: Implement pointer lock element
        return null;
    }
    /**
     * Returns inner HTML.
     *
     * @returns HTML.
     */
    get innerHTML() {
        const xmlSerializer = new XMLSerializer();
        let xml = '';
        for (const node of this[PropertySymbol.nodeArray]) {
            xml += xmlSerializer.serializeToString(node);
        }
        return xml;
    }
    /**
     * Sets inner HTML.
     *
     * @param html HTML.
     */
    set innerHTML(html) {
        const childNodes = this[PropertySymbol.nodeArray];
        while (childNodes.length) {
            this.removeChild(childNodes[0]);
        }
        XMLParser.parse(this[PropertySymbol.ownerDocument], html, { rootNode: this });
    }
    /**
     * Returns adopted style sheets.
     *
     * @returns Adopted style sheets.
     */
    get adoptedStyleSheets() {
        return this[PropertySymbol.adoptedStyleSheets];
    }
    /**
     * Sets adopted style sheets.
     *
     * @param value Adopted style sheets.
     */
    set adoptedStyleSheets(value) {
        this[PropertySymbol.adoptedStyleSheets] = value;
    }
    /**
     * Returns active element.
     *
     * @returns Active element.
     */
    get activeElement() {
        const activeElement = this[PropertySymbol.ownerDocument][PropertySymbol.activeElement];
        if (activeElement &&
            activeElement[PropertySymbol.isConnected] &&
            activeElement.getRootNode() === this) {
            return activeElement;
        }
        return null;
    }
    /**
     * Returns an array of all Animation objects currently in effect, whose target elements are descendants of the shadow tree.
     *
     * @returns Array of animations.
     */
    getAnimations() {
        // TODO: Implement getAnimations()
        return [];
    }
    /**
     * Parses a string of HTML into a document fragment, without sanitization, which then replaces the shadowroot's original subtree. The HTML string may include declarative shadow roots, which would be parsed as template elements the HTML was set using ShadowRoot.innerHTML.
     *
     * @param html HTML.
     */
    setHTMLUnsafe(html) {
        // TODO: Implement support for declarative shadow roots
        const childNodes = this[PropertySymbol.nodeArray];
        while (childNodes.length) {
            this.removeChild(childNodes[0]);
        }
        XMLParser.parse(this[PropertySymbol.ownerDocument], html, { rootNode: this });
    }
    /**
     * Converts to string.
     *
     * @returns String.
     */
    toString() {
        return this.innerHTML;
    }
    /**
     * @override
     */
    [PropertySymbol.cloneNode](deep = false) {
        const clone = super[PropertySymbol.cloneNode](deep);
        clone[PropertySymbol.mode] = this[PropertySymbol.mode];
        clone[PropertySymbol.clonable] = this[PropertySymbol.clonable];
        clone[PropertySymbol.delegatesFocus] = this[PropertySymbol.delegatesFocus];
        clone[PropertySymbol.serializable] = this[PropertySymbol.serializable];
        clone[PropertySymbol.slotAssignment] = this[PropertySymbol.slotAssignment];
        return clone;
    }
}
//# sourceMappingURL=ShadowRoot.js.map