/**
 * Node utility.
 */
export default class ClassMethodBinder {
    /**
     * Binds methods to a target.
     *
     * @param target Target.
     * @param classes Classes.
     * @param [options] Options.
     * @param [options.bindSymbols] Bind symbol methods.
     * @param [options.forwardToPrototype] Forwards the method calls to the prototype. This makes it possible for test tools to override methods on the prototype (e.g. Object.defineProperty(HTMLCollection.prototype, 'item', {})).
     * @param [options.proxy] Bind methods using a proxy.
     */
    static bindMethods(target: Object, classes: any[], options?: {
        bindSymbols?: boolean;
        forwardToPrototype?: boolean;
        proxy?: any;
    }): void;
}
//# sourceMappingURL=ClassMethodBinder.d.ts.map