"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const SVGGraphicsElement_js_1 = __importDefault(require("./SVGGraphicsElement.cjs"));
const SVGRect_js_1 = __importDefault(require("./SVGRect.cjs"));
const SVGPoint_js_1 = __importDefault(require("./SVGPoint.cjs"));
const SVGLength_js_1 = __importDefault(require("./SVGLength.cjs"));
const SVGAngle_js_1 = __importDefault(require("./SVGAngle.cjs"));
const SVGNumber_js_1 = __importDefault(require("./SVGNumber.cjs"));
const SVGTransform_js_1 = __importDefault(require("./SVGTransform.cjs"));
const SVGAnimatedRect_js_1 = __importDefault(require("./SVGAnimatedRect.cjs"));
const PropertySymbol = __importStar(require("../../PropertySymbol.cjs"));
/**
 * SVGSVGElement.
 */
class SVGSVGElement extends SVGGraphicsElement_js_1.default {
    // Events
    onafterprint = null;
    onbeforeprint = null;
    onbeforeunload = null;
    ongamepadconnected = null;
    ongamepaddisconnected = null;
    onhashchange = null;
    onlanguagechange = null;
    onmessage = null;
    onmessageerror = null;
    onoffline = null;
    ononline = null;
    onpagehide = null;
    onpageshow = null;
    onpopstate = null;
    onrejectionhandled = null;
    onstorage = null;
    onunhandledrejection = null;
    onunload = null;
    /**
     * Returns preserveAspectRatio.
     *
     * @returns PreserveAspectRatio.
     */
    get preserveAspectRatio() {
        return this.getAttributeNS(null, 'preserveAspectRatio') || 'xMidYMid meet';
    }
    /**
     * Sets preserveAspectRatio.
     *
     * @param preserveAspectRatio PreserveAspectRatio.
     */
    set preserveAspectRatio(preserveAspectRatio) {
        this.setAttributeNS(null, 'preserveAspectRatio', preserveAspectRatio);
    }
    /**
     * Returns width.
     *
     * @returns Width.
     */
    get width() {
        return this.getAttributeNS(null, 'width') || '';
    }
    /**
     * Sets width.
     *
     * @param width Width.
     */
    set width(width) {
        this.setAttributeNS(null, 'width', width);
    }
    /**
     * Returns height.
     *
     * @returns Height.
     */
    get height() {
        return this.getAttributeNS(null, 'height') || '';
    }
    /**
     * Sets height.
     *
     * @param height Height.
     */
    set height(height) {
        this.setAttributeNS(null, 'height', height);
    }
    /**
     * Returns x.
     *
     * @returns X.
     */
    get x() {
        return this.getAttributeNS(null, 'x') || '';
    }
    /**
     * Sets x.
     *
     * @param x X.
     */
    set x(x) {
        this.setAttributeNS(null, 'x', x);
    }
    /**
     * Returns y.
     *
     * @returns Y.
     */
    get y() {
        return this.getAttributeNS(null, 'y') || '';
    }
    /**
     * Sets y.
     *
     * @param y Y.
     */
    set y(y) {
        this.setAttributeNS(null, 'y', y);
    }
    /**
     * Returns contentScriptType.
     *
     * @returns ContentScriptType.
     */
    get contentScriptType() {
        return this.getAttributeNS(null, 'contentScriptType') || '';
    }
    /**
     * Sets contentScriptType.
     *
     * @param contentScriptType ContentScriptType.
     */
    set contentScriptType(contentScriptType) {
        this.setAttributeNS(null, 'contentScriptType', contentScriptType);
    }
    /**
     * Returns currentScale.
     *
     * @returns CurrentScale.
     */
    get currentScale() {
        const currentScale = this.getAttributeNS(null, 'currentScale');
        if (currentScale !== null) {
            return parseFloat(currentScale);
        }
        return 1;
    }
    /**
     * Sets currentScale.
     *
     * @param currentScale CurrentScale.
     */
    set currentScale(currentScale) {
        this.setAttributeNS(null, 'currentScale', String(currentScale));
    }
    /**
     * Returns viewport.
     *
     * @returns SVG rect.
     */
    get viewport() {
        return new SVGRect_js_1.default();
    }
    /**
     * Returns current translate.
     *
     * @returns SVG point.
     */
    get currentTranslate() {
        return new SVGPoint_js_1.default();
    }
    /**
     * Returns view box.
     *
     * @returns Viewbox.
     */
    get viewBox() {
        const rect = new SVGAnimatedRect_js_1.default();
        const viewBox = this.getAttribute('viewBox');
        const list = viewBox.split(/\s+/);
        rect.baseVal.x = Number(list[0]);
        rect.baseVal.y = Number(list[1]);
        rect.baseVal.width = Number(list[2]);
        rect.baseVal.height = Number(list[3]);
        return rect;
    }
    /**
     * Pauses animation.
     */
    pauseAnimations() { }
    /**
     * Unpauses animation.
     */
    unpauseAnimations() { }
    /**
     * Returns "true" if animation is paused.
     *
     * @returns "true" if animation is paused.
     */
    animationsPaused() {
        return false;
    }
    /**
     * Returns the current time in seconds relative to the start time for the current SVG document fragment.
     *
     * @returns Current time.
     */
    getCurrentTime() {
        return 0;
    }
    /**
     * Sets current time.
     */
    setCurrentTime() { }
    /**
     * Returns intersection list.
     *
     * @returns Intersection list.
     */
    getIntersectionList() {
        return [];
    }
    /**
     * Returns enclousure list.
     *
     * @returns Enclousure list.
     */
    getEnclosureList() {
        return [];
    }
    /**
     * Returns true if the rendered content of the given element intersects the supplied rectangle.
     *
     * @returns Intersection state.
     */
    checkIntersection() {
        return false;
    }
    /**
     * Returns true if the rendered content of the given element is entirely contained within the supplied rectangle.
     *
     * @returns Enclousure state.
     */
    checkEnclosure() {
        return false;
    }
    /**
     * Unselects any selected objects, including any selections of text strings and type-in bars.
     */
    deselectAll() { }
    /**
     * Returns a number.
     *
     * @returns Number.
     */
    createSVGNumber() {
        return new SVGNumber_js_1.default();
    }
    /**
     * Returns a length.
     *
     * @returns Length.
     */
    createSVGLength() {
        return new SVGLength_js_1.default();
    }
    /**
     * Returns a angle.
     *
     * @returns Angle.
     */
    createSVGAngle() {
        return new SVGAngle_js_1.default();
    }
    /**
     * Returns a point.
     *
     * @returns Point.
     */
    createSVGPoint() {
        return new SVGPoint_js_1.default();
    }
    /**
     * Returns a rect.
     *
     * @returns Rect.
     */
    createSVGRect() {
        return new SVGRect_js_1.default();
    }
    /**
     * Returns a transform.
     *
     * @returns Transform.
     */
    createSVGTransform() {
        return new SVGTransform_js_1.default();
    }
    /**
     * @override
     */
    [PropertySymbol.cloneNode](deep = false) {
        return super[PropertySymbol.cloneNode](deep);
    }
}
exports.default = SVGSVGElement;
//# sourceMappingURL=SVGSVGElement.cjs.map