"use strict";
/* eslint-disable filenames/match-exported */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const PropertySymbol = __importStar(require("../../PropertySymbol.cjs"));
/**
 * Named Node Map.
 *
 * @see https://developer.mozilla.org/en-US/docs/Web/API/NamedNodeMap
 */
class NamedNodeMapProxyFactory {
    /**
     * Constructor.
     *
     * @param namedNodeMap
     */
    static createProxy(namedNodeMap) {
        const namedItems = namedNodeMap[PropertySymbol.namedItems];
        const namespaceItems = namedNodeMap[PropertySymbol.namespaceItems];
        return new Proxy(namedNodeMap, {
            get: (target, property) => {
                if (property === 'length') {
                    return namespaceItems.size;
                }
                if (property in target || typeof property === 'symbol') {
                    return target[property];
                }
                const index = Number(property);
                if (!isNaN(index)) {
                    return Array.from(namespaceItems.values())[index];
                }
                return target.getNamedItem(property) || undefined;
            },
            set(target, property, newValue) {
                if (typeof property === 'symbol') {
                    target[property] = newValue;
                    return true;
                }
                const index = Number(property);
                if (isNaN(index)) {
                    target[property] = newValue;
                }
                return true;
            },
            deleteProperty(target, property) {
                if (typeof property === 'symbol') {
                    delete target[property];
                    return true;
                }
                const index = Number(property);
                if (isNaN(index)) {
                    delete target[property];
                }
                return true;
            },
            ownKeys() {
                const keys = Array.from(namedItems.keys());
                for (let i = 0, max = namespaceItems.size; i < max; i++) {
                    keys.push(String(i));
                }
                return keys;
            },
            has(target, property) {
                if (typeof property === 'symbol') {
                    return false;
                }
                if (property in target || namedItems.has(property)) {
                    return true;
                }
                const index = Number(property);
                if (!isNaN(index) && index >= 0 && index < namespaceItems.size) {
                    return true;
                }
                return false;
            },
            defineProperty(target, property, descriptor) {
                if (property in target) {
                    Object.defineProperty(target, property, descriptor);
                    return true;
                }
                return false;
            },
            getOwnPropertyDescriptor(target, property) {
                if (property in target || typeof property === 'symbol') {
                    return;
                }
                const index = Number(property);
                if (!isNaN(index) && index >= 0 && index < namespaceItems.size) {
                    return {
                        value: Array.from(namespaceItems.values())[index],
                        writable: false,
                        enumerable: true,
                        configurable: true
                    };
                }
                const namedItem = target.getNamedItem(property);
                if (namedItem) {
                    return {
                        value: namedItem,
                        writable: false,
                        enumerable: true,
                        configurable: true
                    };
                }
            }
        });
    }
}
exports.default = NamedNodeMapProxyFactory;
//# sourceMappingURL=NamedNodeMapProxyFactory.cjs.map