"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const DOMExceptionNameEnum_js_1 = __importDefault(require("../../exception/DOMExceptionNameEnum.cjs"));
const CSSStyleDeclarationElementStyle_js_1 = __importDefault(require("./element-style/CSSStyleDeclarationElementStyle.cjs"));
const CSSStyleDeclarationPropertyManager_js_1 = __importDefault(require("./property-manager/CSSStyleDeclarationPropertyManager.cjs"));
const PropertySymbol = __importStar(require("../../PropertySymbol.cjs"));
/**
 * CSS Style Declaration.
 */
class AbstractCSSStyleDeclaration {
    parentRule = null;
    #style = null;
    #ownerElement;
    #computed;
    #elementStyle = null;
    /**
     * Constructor.
     *
     * @param [ownerElement] Computed style element.
     * @param [computed] Computed.
     */
    constructor(ownerElement = null, computed = false) {
        this.#style = !ownerElement ? new CSSStyleDeclarationPropertyManager_js_1.default() : null;
        this.#ownerElement = ownerElement;
        this.#computed = ownerElement ? computed : false;
        this.#elementStyle = ownerElement
            ? new CSSStyleDeclarationElementStyle_js_1.default(ownerElement, this.#computed)
            : null;
    }
    /**
     * Returns length.
     *
     * @returns Length.
     */
    get length() {
        if (this.#ownerElement) {
            const style = this.#elementStyle.getElementStyle();
            return style.size();
        }
        return this.#style.size();
    }
    /**
     * Returns the style decleration as a CSS text.
     *
     * @returns CSS text.
     */
    get cssText() {
        if (this.#ownerElement) {
            if (this.#computed) {
                return '';
            }
            return this.#elementStyle.getElementStyle().toString();
        }
        return this.#style.toString();
    }
    /**
     * Sets CSS text.
     *
     * @param cssText CSS text.
     */
    set cssText(cssText) {
        if (this.#computed) {
            throw new this[PropertySymbol.window].DOMException(`Failed to execute 'cssText' on 'CSSStyleDeclaration': These styles are computed, and the properties are therefore read-only.`, DOMExceptionNameEnum_js_1.default.domException);
        }
        if (this.#ownerElement) {
            this.#ownerElement.setAttribute('style', new CSSStyleDeclarationPropertyManager_js_1.default({ cssText }).toString());
        }
        else {
            this.#style = new CSSStyleDeclarationPropertyManager_js_1.default({ cssText });
        }
    }
    /**
     * Returns item.
     *
     * @param index Index.
     * @returns Item.
     */
    item(index) {
        if (this.#ownerElement) {
            return this.#elementStyle.getElementStyle().item(index);
        }
        return this.#style.item(index);
    }
    /**
     * Set a property.
     *
     * @param name Property name.
     * @param value Value. Must not contain "!important" as that should be set using the priority parameter.
     * @param [priority] Can be "important", or an empty string.
     */
    setProperty(name, value, priority) {
        if (this.#computed) {
            throw new this[PropertySymbol.window].DOMException(`Failed to execute 'setProperty' on 'CSSStyleDeclaration': These styles are computed, and therefore the '${name}' property is read-only.`, DOMExceptionNameEnum_js_1.default.domException);
        }
        if (priority !== '' && priority !== undefined && priority !== 'important') {
            return;
        }
        const stringValue = String(value);
        if (!stringValue) {
            this.removeProperty(name);
        }
        else if (this.#ownerElement) {
            const style = this.#elementStyle.getElementStyle();
            style.set(name, stringValue, !!priority);
            this.#ownerElement.setAttribute('style', style.toString());
        }
        else {
            this.#style.set(name, stringValue, !!priority);
        }
    }
    /**
     * Removes a property.
     *
     * @param name Property name in kebab case.
     * @param value Value. Must not contain "!important" as that should be set using the priority parameter.
     * @param [priority] Can be "important", or an empty string.
     */
    removeProperty(name) {
        if (this.#computed) {
            throw new this[PropertySymbol.window].DOMException(`Failed to execute 'removeProperty' on 'CSSStyleDeclaration': These styles are computed, and therefore the '${name}' property is read-only.`, DOMExceptionNameEnum_js_1.default.domException);
        }
        if (this.#ownerElement) {
            const style = this.#elementStyle.getElementStyle();
            style.remove(name);
            const newCSSText = style.toString();
            if (newCSSText) {
                this.#ownerElement.setAttribute('style', newCSSText);
            }
            else {
                this.#ownerElement.removeAttribute('style');
            }
        }
        else {
            this.#style.remove(name);
        }
    }
    /**
     * Returns a property.
     *
     * @param name Property name in kebab case.
     * @returns Property value.
     */
    getPropertyValue(name) {
        if (this.#ownerElement) {
            const style = this.#elementStyle.getElementStyle();
            return style.get(name)?.value || '';
        }
        return this.#style.get(name)?.value || '';
    }
    /**
     * Returns a property.
     *
     * @param name Property name in kebab case.
     * @returns "important" if set to be important.
     */
    getPropertyPriority(name) {
        if (this.#ownerElement) {
            const style = this.#elementStyle.getElementStyle();
            return style.get(name)?.important ? 'important' : '';
        }
        return this.#style.get(name)?.important ? 'important' : '';
    }
}
exports.default = AbstractCSSStyleDeclaration;
//# sourceMappingURL=AbstractCSSStyleDeclaration.cjs.map