"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const HTMLElementConfigContentModelEnum_js_1 = __importDefault(require("./HTMLElementConfigContentModelEnum.cjs"));
/**
 * @see https://html.spec.whatwg.org/multipage/indices.html
 */
exports.default = {
    a: {
        className: 'HTMLAnchorElement',
        localName: 'a',
        tagName: 'A',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.noSelfDescendants
    },
    abbr: {
        className: 'HTMLElement',
        localName: 'abbr',
        tagName: 'ABBR',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    address: {
        className: 'HTMLElement',
        localName: 'address',
        tagName: 'ADDRESS',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    area: {
        className: 'HTMLAreaElement',
        localName: 'area',
        tagName: 'AREA',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.noDescendants
    },
    article: {
        className: 'HTMLElement',
        localName: 'article',
        tagName: 'ARTICLE',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    aside: {
        className: 'HTMLElement',
        localName: 'aside',
        tagName: 'ASIDE',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    audio: {
        className: 'HTMLAudioElement',
        localName: 'audio',
        tagName: 'AUDIO',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    b: {
        className: 'HTMLElement',
        localName: 'b',
        tagName: 'B',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    base: {
        className: 'HTMLBaseElement',
        localName: 'base',
        tagName: 'BASE',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.noDescendants
    },
    bdi: {
        className: 'HTMLElement',
        localName: 'bdi',
        tagName: 'BDI',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    bdo: {
        className: 'HTMLElement',
        localName: 'bdo',
        tagName: 'BDO',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    body: {
        className: 'HTMLBodyElement',
        localName: 'body',
        tagName: 'BODY',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    template: {
        className: 'HTMLTemplateElement',
        localName: 'template',
        tagName: 'TEMPLATE',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    form: {
        className: 'HTMLFormElement',
        localName: 'form',
        tagName: 'FORM',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    input: {
        className: 'HTMLInputElement',
        localName: 'input',
        tagName: 'INPUT',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.noDescendants
    },
    textarea: {
        className: 'HTMLTextAreaElement',
        localName: 'textarea',
        tagName: 'TEXTAREA',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    script: {
        className: 'HTMLScriptElement',
        localName: 'script',
        tagName: 'SCRIPT',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.rawText
    },
    img: {
        className: 'HTMLImageElement',
        localName: 'img',
        tagName: 'IMG',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.noDescendants
    },
    link: {
        className: 'HTMLLinkElement',
        localName: 'link',
        tagName: 'LINK',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.noDescendants
    },
    style: {
        className: 'HTMLStyleElement',
        localName: 'style',
        tagName: 'STYLE',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.rawText
    },
    label: {
        className: 'HTMLLabelElement',
        localName: 'label',
        tagName: 'LABEL',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    slot: {
        className: 'HTMLSlotElement',
        localName: 'slot',
        tagName: 'SLOT',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    meta: {
        className: 'HTMLMetaElement',
        localName: 'meta',
        tagName: 'META',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.noDescendants
    },
    blockquote: {
        className: 'HTMLQuoteElement',
        localName: 'blockquote',
        tagName: 'BLOCKQUOTE',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    br: {
        className: 'HTMLBRElement',
        localName: 'br',
        tagName: 'BR',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.noDescendants
    },
    button: {
        className: 'HTMLButtonElement',
        localName: 'button',
        tagName: 'BUTTON',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    canvas: {
        className: 'HTMLCanvasElement',
        localName: 'canvas',
        tagName: 'CANVAS',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    caption: {
        className: 'HTMLTableCaptionElement',
        localName: 'caption',
        tagName: 'CAPTION',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    cite: {
        className: 'HTMLElement',
        localName: 'cite',
        tagName: 'CITE',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    code: {
        className: 'HTMLElement',
        localName: 'code',
        tagName: 'CODE',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    col: {
        className: 'HTMLTableColElement',
        localName: 'col',
        tagName: 'COL',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.noDescendants
    },
    colgroup: {
        className: 'HTMLTableColElement',
        localName: 'colgroup',
        tagName: 'COLGROUP',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    data: {
        className: 'HTMLDataElement',
        localName: 'data',
        tagName: 'DATA',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    datalist: {
        className: 'HTMLDataListElement',
        localName: 'datalist',
        tagName: 'DATALIST',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    dd: {
        className: 'HTMLElement',
        localName: 'dd',
        tagName: 'DD',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.noFirstLevelSelfDescendants
    },
    del: {
        className: 'HTMLModElement',
        localName: 'del',
        tagName: 'DEL',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    details: {
        className: 'HTMLDetailsElement',
        localName: 'details',
        tagName: 'DETAILS',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    dfn: {
        className: 'HTMLElement',
        localName: 'dfn',
        tagName: 'DFN',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    dialog: {
        className: 'HTMLDialogElement',
        localName: 'dialog',
        tagName: 'DIALOG',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    div: {
        className: 'HTMLDivElement',
        localName: 'div',
        tagName: 'DIV',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    dl: {
        className: 'HTMLDListElement',
        localName: 'dl',
        tagName: 'DL',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    dt: {
        className: 'HTMLElement',
        localName: 'dt',
        tagName: 'DT',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.noFirstLevelSelfDescendants
    },
    em: {
        className: 'HTMLElement',
        localName: 'em',
        tagName: 'EM',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    embed: {
        className: 'HTMLEmbedElement',
        localName: 'embed',
        tagName: 'EMBED',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.noDescendants
    },
    fieldset: {
        className: 'HTMLFieldSetElement',
        localName: 'fieldset',
        tagName: 'FIELDSET',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    figcaption: {
        className: 'HTMLElement',
        localName: 'figcaption',
        tagName: 'FIGCAPTION',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    figure: {
        className: 'HTMLElement',
        localName: 'figure',
        tagName: 'FIGURE',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    footer: {
        className: 'HTMLElement',
        localName: 'footer',
        tagName: 'FOOTER',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    h1: {
        className: 'HTMLHeadingElement',
        localName: 'h1',
        tagName: 'H1',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.noFirstLevelSelfDescendants
    },
    h2: {
        className: 'HTMLHeadingElement',
        localName: 'h2',
        tagName: 'H2',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.noFirstLevelSelfDescendants
    },
    h3: {
        className: 'HTMLHeadingElement',
        localName: 'h3',
        tagName: 'H3',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.noFirstLevelSelfDescendants
    },
    h4: {
        className: 'HTMLHeadingElement',
        localName: 'h4',
        tagName: 'H4',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.noFirstLevelSelfDescendants
    },
    h5: {
        className: 'HTMLHeadingElement',
        localName: 'h5',
        tagName: 'H5',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.noFirstLevelSelfDescendants
    },
    h6: {
        className: 'HTMLHeadingElement',
        localName: 'h6',
        tagName: 'H6',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.noFirstLevelSelfDescendants
    },
    head: {
        className: 'HTMLHeadElement',
        localName: 'head',
        tagName: 'HEAD',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    header: {
        className: 'HTMLElement',
        localName: 'header',
        tagName: 'HEADER',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    hgroup: {
        className: 'HTMLElement',
        localName: 'hgroup',
        tagName: 'HGROUP',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    hr: {
        className: 'HTMLHRElement',
        localName: 'hr',
        tagName: 'HR',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.noDescendants
    },
    html: {
        className: 'HTMLHtmlElement',
        localName: 'html',
        tagName: 'HTML',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    i: {
        className: 'HTMLElement',
        localName: 'i',
        tagName: 'I',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    iframe: {
        className: 'HTMLIFrameElement',
        localName: 'iframe',
        tagName: 'IFRAME',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    ins: {
        className: 'HTMLModElement',
        localName: 'ins',
        tagName: 'INS',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    kbd: {
        className: 'HTMLElement',
        localName: 'kbd',
        tagName: 'KBD',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    legend: {
        className: 'HTMLLegendElement',
        localName: 'legend',
        tagName: 'LEGEND',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    li: {
        className: 'HTMLLIElement',
        localName: 'li',
        tagName: 'LI',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.noFirstLevelSelfDescendants
    },
    main: {
        className: 'HTMLElement',
        localName: 'main',
        tagName: 'MAIN',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    map: {
        className: 'HTMLMapElement',
        localName: 'map',
        tagName: 'MAP',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    mark: {
        className: 'HTMLElement',
        localName: 'mark',
        tagName: 'MARK',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    menu: {
        className: 'HTMLMenuElement',
        localName: 'menu',
        tagName: 'MENU',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    meter: {
        className: 'HTMLMeterElement',
        localName: 'meter',
        tagName: 'METER',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    nav: {
        className: 'HTMLElement',
        localName: 'nav',
        tagName: 'NAV',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    noscript: {
        className: 'HTMLElement',
        localName: 'noscript',
        tagName: 'NOSCRIPT',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    object: {
        className: 'HTMLObjectElement',
        localName: 'object',
        tagName: 'OBJECT',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    ol: {
        className: 'HTMLOListElement',
        localName: 'ol',
        tagName: 'OL',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    optgroup: {
        className: 'HTMLOptGroupElement',
        localName: 'optgroup',
        tagName: 'OPTGROUP',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    option: {
        className: 'HTMLOptionElement',
        localName: 'option',
        tagName: 'OPTION',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.noFirstLevelSelfDescendants
    },
    output: {
        className: 'HTMLOutputElement',
        localName: 'output',
        tagName: 'OUTPUT',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    p: {
        className: 'HTMLParagraphElement',
        localName: 'p',
        tagName: 'P',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    param: {
        className: 'HTMLParamElement',
        localName: 'param',
        tagName: 'PARAM',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.noDescendants
    },
    picture: {
        className: 'HTMLPictureElement',
        localName: 'picture',
        tagName: 'PICTURE',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    pre: {
        className: 'HTMLPreElement',
        localName: 'pre',
        tagName: 'PRE',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    progress: {
        className: 'HTMLProgressElement',
        localName: 'progress',
        tagName: 'PROGRESS',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    q: {
        className: 'HTMLQuoteElement',
        localName: 'q',
        tagName: 'Q',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    rb: {
        className: 'HTMLElement',
        localName: 'rb',
        tagName: 'RB',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    rp: {
        className: 'HTMLElement',
        localName: 'rp',
        tagName: 'RP',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    rt: {
        className: 'HTMLElement',
        localName: 'rt',
        tagName: 'RT',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    rtc: {
        className: 'HTMLElement',
        localName: 'rtc',
        tagName: 'RTC',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    ruby: {
        className: 'HTMLElement',
        localName: 'ruby',
        tagName: 'RUBY',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    s: {
        className: 'HTMLElement',
        localName: 's',
        tagName: 'S',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    samp: {
        className: 'HTMLElement',
        localName: 'samp',
        tagName: 'SAMP',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    section: {
        className: 'HTMLElement',
        localName: 'section',
        tagName: 'SECTION',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    select: {
        className: 'HTMLSelectElement',
        localName: 'select',
        tagName: 'SELECT',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    small: {
        className: 'HTMLElement',
        localName: 'small',
        tagName: 'SMALL',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    source: {
        className: 'HTMLSourceElement',
        localName: 'source',
        tagName: 'SOURCE',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.noDescendants
    },
    span: {
        className: 'HTMLSpanElement',
        localName: 'span',
        tagName: 'SPAN',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    strong: {
        className: 'HTMLElement',
        localName: 'strong',
        tagName: 'STRONG',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    sub: {
        className: 'HTMLElement',
        localName: 'sub',
        tagName: 'SUB',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    summary: {
        className: 'HTMLElement',
        localName: 'summary',
        tagName: 'SUMMARY',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    sup: {
        className: 'HTMLElement',
        localName: 'sup',
        tagName: 'SUP',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    table: {
        className: 'HTMLTableElement',
        localName: 'table',
        tagName: 'TABLE',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.noFirstLevelSelfDescendants
    },
    tbody: {
        className: 'HTMLTableSectionElement',
        localName: 'tbody',
        tagName: 'TBODY',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    td: {
        className: 'HTMLTableCellElement',
        localName: 'td',
        tagName: 'TD',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    tfoot: {
        className: 'HTMLTableSectionElement',
        localName: 'tfoot',
        tagName: 'TFOOT',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    th: {
        className: 'HTMLTableCellElement',
        localName: 'th',
        tagName: 'TH',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    thead: {
        className: 'HTMLTableSectionElement',
        localName: 'thead',
        tagName: 'THEAD',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    time: {
        className: 'HTMLTimeElement',
        localName: 'time',
        tagName: 'TIME',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    title: {
        className: 'HTMLTitleElement',
        localName: 'title',
        tagName: 'TITLE',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    tr: {
        className: 'HTMLTableRowElement',
        localName: 'tr',
        tagName: 'TR',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    track: {
        className: 'HTMLTrackElement',
        localName: 'track',
        tagName: 'TRACK',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.noDescendants
    },
    u: {
        className: 'HTMLElement',
        localName: 'u',
        tagName: 'U',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    ul: {
        className: 'HTMLUListElement',
        localName: 'ul',
        tagName: 'UL',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    var: {
        className: 'HTMLElement',
        localName: 'var',
        tagName: 'VAR',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    video: {
        className: 'HTMLVideoElement',
        localName: 'video',
        tagName: 'VIDEO',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.anyDescendants
    },
    wbr: {
        className: 'HTMLElement',
        localName: 'wbr',
        tagName: 'WBR',
        contentModel: HTMLElementConfigContentModelEnum_js_1.default.noDescendants
    }
};
//# sourceMappingURL=HTMLElementConfig.cjs.map