"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const version_js_1 = __importDefault(require("../version.cjs"));
const BrowserErrorCaptureEnum_js_1 = __importDefault(require("./enums/BrowserErrorCaptureEnum.cjs"));
const BrowserNavigationCrossOriginPolicyEnum_js_1 = __importDefault(require("./enums/BrowserNavigationCrossOriginPolicyEnum.cjs"));
exports.default = {
    disableJavaScriptEvaluation: false,
    disableJavaScriptFileLoading: false,
    disableCSSFileLoading: false,
    disableIframePageLoading: false,
    disableComputedStyleRendering: false,
    disableErrorCapturing: false,
    errorCapture: BrowserErrorCaptureEnum_js_1.default.tryAndCatch,
    enableFileSystemHttpRequests: false,
    timer: {
        maxTimeout: -1,
        maxIntervalTime: -1,
        maxIntervalIterations: -1,
        preventTimerLoops: false
    },
    navigation: {
        disableMainFrameNavigation: false,
        disableChildFrameNavigation: false,
        disableChildPageNavigation: false,
        disableFallbackToSetURL: false,
        crossOriginPolicy: BrowserNavigationCrossOriginPolicyEnum_js_1.default.anyOrigin
    },
    navigator: {
        userAgent: `Mozilla/5.0 (X11; ${process.platform.charAt(0).toUpperCase() + process.platform.slice(1) + ' ' + process.arch}) AppleWebKit/537.36 (KHTML, like Gecko) HappyDOM/${version_js_1.default.version}`,
        maxTouchPoints: 0
    },
    device: {
        prefersColorScheme: 'light',
        mediaType: 'screen'
    }
};
//# sourceMappingURL=DefaultBrowserSettings.cjs.map