"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.processEntrypoint = processEntrypoint;
var _AbortError = require("../actions/AbortError");
function dispose_SuppressedError(r, e) { return "undefined" != typeof SuppressedError ? dispose_SuppressedError = SuppressedError : (dispose_SuppressedError = function (r, e) { this.suppressed = r, this.error = e, this.stack = new Error().stack; }, dispose_SuppressedError.prototype = Object.create(Error.prototype, { constructor: { value: dispose_SuppressedError, writable: !0, configurable: !0 } })), new dispose_SuppressedError(r, e); }
function _dispose(r, e, s) { function next() { for (; r.length > 0;) try { var o = r.pop(), p = o.d.call(o.v); if (o.a) return Promise.resolve(p).then(next, err); } catch (r) { return err(r); } if (s) throw e; } function err(r) { return e = s ? new dispose_SuppressedError(r, e) : r, s = !0, next(); } return next(); }
function _using(o, e, n) { if (null == e) return e; if ("object" != typeof e) throw new TypeError("using declarations can only be used with objects, null, or undefined."); if (n) var r = e[Symbol.asyncDispose || Symbol.for("Symbol.asyncDispose")]; if (null == r && (r = e[Symbol.dispose || Symbol.for("Symbol.dispose")]), "function" != typeof r) throw new TypeError("Property [Symbol.dispose] is not a function."); return o.push({ v: e, d: r, a: n }), e; }
/**
 * The first stage of processing an entrypoint.
 * This stage is responsible for:
 * - scheduling the explodeReexports action
 * - scheduling the transform action
 * - rescheduling itself if the entrypoint is superseded
 */
function* processEntrypoint() {
  const {
    only,
    log
  } = this.entrypoint;
  log('start processing (only: %o)', only);
  try {
    try {
      var _stack = [];
      const abortSignal = _using(_stack, this.createAbortSignal());
      yield ['explodeReexports', this.entrypoint, undefined, abortSignal];
      const result = yield* this.getNext('transform', this.entrypoint, undefined, abortSignal);
      this.entrypoint.assertNotSuperseded();
      this.entrypoint.setTransformResult(result);
      log('entrypoint processing finished');
    } catch (_) {
      var _error = _;
      var _hasError = true;
    } finally {
      _dispose(_stack, _error, _hasError);
    }
  } catch (e) {
    if ((0, _AbortError.isAborted)(e) && this.entrypoint.supersededWith) {
      log('processing aborted, schedule the next attempt');
      yield* this.getNext('processEntrypoint', this.entrypoint.supersededWith, undefined, null);
      return;
    }
    log(`Unhandled error: %O`, e);
    throw e;
  }
}
//# sourceMappingURL=processEntrypoint.js.map