"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OPS = void 0;
const log_1 = require("../../util/log");
async function execute(ctx, op) {
    var _a, _b;
    const resOps = op.value;
    for (let resOp of resOps) {
        try {
            if (resOp.text) {
                const { path, file, text } = resOp;
                await ((_a = ctx.project.android) === null || _a === void 0 ? void 0 : _a.addResource(path, file, text));
            }
            else if (resOp.source) {
                const { path, file, source } = resOp;
                await ((_b = ctx.project.android) === null || _b === void 0 ? void 0 : _b.copyToResources(path, file, source));
            }
        }
        catch (e) {
            log_1.logger.warn(`Skipping resource file operation: ${e.message}`);
        }
    }
    return [];
}
exports.default = execute;
exports.OPS = [
    'android.res'
];
//# sourceMappingURL=res.js.map