/**
 * Check if there are phrasing mdast nodes.
 *
 * This is needed if a fragment is given, which could just be a sentence, and
 * doesn’t need a wrapper paragraph.
 *
 * @param {Array<Nodes>} nodes
 * @returns {boolean}
 */
export function wrapNeeded(nodes: Array<Nodes>): boolean;
/**
 * Wrap runs of phrasing content into paragraphs, leaving the non-phrasing
 * content as-is.
 *
 * @param {Array<RootContent>} nodes
 *   Content.
 * @returns {Array<BlockContent>}
 *   Content where phrasing is wrapped in paragraphs.
 */
export function wrap(nodes: Array<RootContent>): Array<BlockContent>;
export type BlockContent = import('mdast').BlockContent;
export type Delete = import('mdast').Delete;
export type Link = import('mdast').Link;
export type Nodes = import('mdast').Nodes;
export type Paragraph = import('mdast').Paragraph;
export type Parents = import('mdast').Parents;
export type PhrasingContent = import('mdast').PhrasingContent;
export type RootContent = import('mdast').RootContent;
export type DoNotTouchItRegistersDataFields = typeof import("mdast-util-to-hast");
