/**
 * @param {State} state
 *   State.
 * @param {Readonly<Element>} node
 *   hast element to transform.
 * @returns {List | undefined}
 *   mdast node.
 */
export function dl(state: State, node: Readonly<Element>): List | undefined;
export type Element = import('hast').Element;
export type ElementContent = import('hast').ElementContent;
export type BlockContent = import('mdast').BlockContent;
export type DefinitionContent = import('mdast').DefinitionContent;
export type List = import('mdast').List;
export type ListContent = import('mdast').ListContent;
export type ListItem = import('mdast').ListItem;
export type State = import('../state.js').State;
/**
 * Title/definition group.
 */
export type Group = {
    /**
     *   One or more titles.
     */
    titles: Array<Element>;
    /**
     *   One or more definitions.
     */
    definitions: Array<ElementContent>;
};
