"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var _BrowserWindow_instances, _a, _BrowserWindow_browserFrame, _BrowserWindow_innerWidth, _BrowserWindow_innerHeight, _BrowserWindow_outerWidth, _BrowserWindow_outerHeight, _BrowserWindow_devicePixelRatio, _BrowserWindow_zeroTimeouts, _BrowserWindow_bindToThisScope, _b, _c, _d, _e;
Object.defineProperty(exports, "__esModule", { value: true });
const CustomElementRegistry_js_1 = __importDefault(require("../custom-element/CustomElementRegistry.cjs"));
const PropertySymbol = __importStar(require("../PropertySymbol.cjs"));
const Document_js_1 = __importDefault(require("../nodes/document/Document.cjs"));
const HTMLDocument_js_1 = __importDefault(require("../nodes/html-document/HTMLDocument.cjs"));
const XMLDocument_js_1 = __importDefault(require("../nodes/xml-document/XMLDocument.cjs"));
const SVGDocument_js_1 = __importDefault(require("../nodes/svg-document/SVGDocument.cjs"));
const Node_js_1 = __importDefault(require("../nodes/node/Node.cjs"));
const NodeFilter_js_1 = __importDefault(require("../tree-walker/NodeFilter.cjs"));
const ShadowRoot_js_1 = __importDefault(require("../nodes/shadow-root/ShadowRoot.cjs"));
const HTMLTemplateElement_js_1 = __importDefault(require("../nodes/html-template-element/HTMLTemplateElement.cjs"));
const HTMLFormElement_js_1 = __importDefault(require("../nodes/html-form-element/HTMLFormElement.cjs"));
const HTMLElement_js_1 = __importDefault(require("../nodes/html-element/HTMLElement.cjs"));
const HTMLUnknownElement_js_1 = __importDefault(require("../nodes/html-unknown-element/HTMLUnknownElement.cjs"));
const HTMLInputElement_js_1 = __importDefault(require("../nodes/html-input-element/HTMLInputElement.cjs"));
const HTMLSelectElement_js_1 = __importDefault(require("../nodes/html-select-element/HTMLSelectElement.cjs"));
const HTMLTextAreaElement_js_1 = __importDefault(require("../nodes/html-text-area-element/HTMLTextAreaElement.cjs"));
const HTMLLinkElement_js_1 = __importDefault(require("../nodes/html-link-element/HTMLLinkElement.cjs"));
const HTMLStyleElement_js_1 = __importDefault(require("../nodes/html-style-element/HTMLStyleElement.cjs"));
const HTMLSlotElement_js_1 = __importDefault(require("../nodes/html-slot-element/HTMLSlotElement.cjs"));
const HTMLLabelElement_js_1 = __importDefault(require("../nodes/html-label-element/HTMLLabelElement.cjs"));
const HTMLMetaElement_js_1 = __importDefault(require("../nodes/html-meta-element/HTMLMetaElement.cjs"));
const HTMLMediaElement_js_1 = __importDefault(require("../nodes/html-media-element/HTMLMediaElement.cjs"));
const HTMLAudioElement_js_1 = __importDefault(require("../nodes/html-audio-element/HTMLAudioElement.cjs"));
const HTMLVideoElement_js_1 = __importDefault(require("../nodes/html-video-element/HTMLVideoElement.cjs"));
const HTMLBaseElement_js_1 = __importDefault(require("../nodes/html-base-element/HTMLBaseElement.cjs"));
const HTMLIFrameElement_js_1 = __importDefault(require("../nodes/html-iframe-element/HTMLIFrameElement.cjs"));
const HTMLDialogElement_js_1 = __importDefault(require("../nodes/html-dialog-element/HTMLDialogElement.cjs"));
const SVGSVGElement_js_1 = __importDefault(require("../nodes/svg-element/SVGSVGElement.cjs"));
const SVGElement_js_1 = __importDefault(require("../nodes/svg-element/SVGElement.cjs"));
const SVGGraphicsElement_js_1 = __importDefault(require("../nodes/svg-element/SVGGraphicsElement.cjs"));
const HTMLScriptElement_js_1 = __importDefault(require("../nodes/html-script-element/HTMLScriptElement.cjs"));
const HTMLImageElement_js_1 = __importDefault(require("../nodes/html-image-element/HTMLImageElement.cjs"));
const CharacterData_js_1 = __importDefault(require("../nodes/character-data/CharacterData.cjs"));
const DocumentType_js_1 = __importDefault(require("../nodes/document-type/DocumentType.cjs"));
const NodeIterator_js_1 = __importDefault(require("../tree-walker/NodeIterator.cjs"));
const TreeWalker_js_1 = __importDefault(require("../tree-walker/TreeWalker.cjs"));
const Event_js_1 = __importDefault(require("../event/Event.cjs"));
const CustomEvent_js_1 = __importDefault(require("../event/events/CustomEvent.cjs"));
const AnimationEvent_js_1 = __importDefault(require("../event/events/AnimationEvent.cjs"));
const KeyboardEvent_js_1 = __importDefault(require("../event/events/KeyboardEvent.cjs"));
const MessageEvent_js_1 = __importDefault(require("../event/events/MessageEvent.cjs"));
const ProgressEvent_js_1 = __importDefault(require("../event/events/ProgressEvent.cjs"));
const MediaQueryListEvent_js_1 = __importDefault(require("../event/events/MediaQueryListEvent.cjs"));
const HashChangeEvent_js_1 = __importDefault(require("../event/events/HashChangeEvent.cjs"));
const TouchEvent_js_1 = __importDefault(require("../event/events/TouchEvent.cjs"));
const Touch_js_1 = __importDefault(require("../event/Touch.cjs"));
const EventTarget_js_1 = __importDefault(require("../event/EventTarget.cjs"));
const MessagePort_js_1 = __importDefault(require("../event/MessagePort.cjs"));
const url_1 = require("url");
const URL_js_1 = __importDefault(require("../url/URL.cjs"));
const Location_js_1 = __importDefault(require("../location/Location.cjs"));
const MutationObserver_js_1 = __importDefault(require("../mutation-observer/MutationObserver.cjs"));
const MutationRecord_js_1 = __importDefault(require("../mutation-observer/MutationRecord.cjs"));
const XMLSerializer_js_1 = __importDefault(require("../xml-serializer/XMLSerializer.cjs"));
const ResizeObserver_js_1 = __importDefault(require("../resize-observer/ResizeObserver.cjs"));
const Blob_js_1 = __importDefault(require("../file/Blob.cjs"));
const File_js_1 = __importDefault(require("../file/File.cjs"));
const DOMException_js_1 = __importDefault(require("../exception/DOMException.cjs"));
const History_js_1 = __importDefault(require("../history/History.cjs"));
const CSSStyleSheet_js_1 = __importDefault(require("../css/CSSStyleSheet.cjs"));
const CSSStyleDeclaration_js_1 = __importDefault(require("../css/declaration/CSSStyleDeclaration.cjs"));
const CSS_js_1 = __importDefault(require("../css/CSS.cjs"));
const CSSUnitValue_js_1 = __importDefault(require("../css/CSSUnitValue.cjs"));
const CSSRule_js_1 = __importDefault(require("../css/CSSRule.cjs"));
const CSSContainerRule_js_1 = __importDefault(require("../css/rules/CSSContainerRule.cjs"));
const CSSFontFaceRule_js_1 = __importDefault(require("../css/rules/CSSFontFaceRule.cjs"));
const CSSKeyframeRule_js_1 = __importDefault(require("../css/rules/CSSKeyframeRule.cjs"));
const CSSKeyframesRule_js_1 = __importDefault(require("../css/rules/CSSKeyframesRule.cjs"));
const CSSMediaRule_js_1 = __importDefault(require("../css/rules/CSSMediaRule.cjs"));
const CSSStyleRule_js_1 = __importDefault(require("../css/rules/CSSStyleRule.cjs"));
const CSSSupportsRule_js_1 = __importDefault(require("../css/rules/CSSSupportsRule.cjs"));
const MouseEvent_js_1 = __importDefault(require("../event/events/MouseEvent.cjs"));
const PointerEvent_js_1 = __importDefault(require("../event/events/PointerEvent.cjs"));
const FocusEvent_js_1 = __importDefault(require("../event/events/FocusEvent.cjs"));
const WheelEvent_js_1 = __importDefault(require("../event/events/WheelEvent.cjs"));
const DataTransfer_js_1 = __importDefault(require("../event/DataTransfer.cjs"));
const DataTransferItem_js_1 = __importDefault(require("../event/DataTransferItem.cjs"));
const DataTransferItemList_js_1 = __importDefault(require("../event/DataTransferItemList.cjs"));
const InputEvent_js_1 = __importDefault(require("../event/events/InputEvent.cjs"));
const UIEvent_js_1 = __importDefault(require("../event/UIEvent.cjs"));
const ErrorEvent_js_1 = __importDefault(require("../event/events/ErrorEvent.cjs"));
const StorageEvent_js_1 = __importDefault(require("../event/events/StorageEvent.cjs"));
const SubmitEvent_js_1 = __importDefault(require("../event/events/SubmitEvent.cjs"));
const Screen_js_1 = __importDefault(require("../screen/Screen.cjs"));
const Storage_js_1 = __importDefault(require("../storage/Storage.cjs"));
const StorageFactory_js_1 = __importDefault(require("../storage/StorageFactory.cjs"));
const HTMLCollection_js_1 = __importDefault(require("../nodes/element/HTMLCollection.cjs"));
const HTMLFormControlsCollection_js_1 = __importDefault(require("../nodes/html-form-element/HTMLFormControlsCollection.cjs"));
const NodeList_js_1 = __importDefault(require("../nodes/node/NodeList.cjs"));
const MediaQueryList_js_1 = __importDefault(require("../match-media/MediaQueryList.cjs"));
const Selection_js_1 = __importDefault(require("../selection/Selection.cjs"));
const Navigator_js_1 = __importDefault(require("../navigator/Navigator.cjs"));
const MimeType_js_1 = __importDefault(require("../navigator/MimeType.cjs"));
const MimeTypeArray_js_1 = __importDefault(require("../navigator/MimeTypeArray.cjs"));
const Plugin_js_1 = __importDefault(require("../navigator/Plugin.cjs"));
const PluginArray_js_1 = __importDefault(require("../navigator/PluginArray.cjs"));
const Fetch_js_1 = __importDefault(require("../fetch/Fetch.cjs"));
const DOMRect_js_1 = __importDefault(require("../nodes/element/DOMRect.cjs"));
const DOMRectReadOnly_js_1 = __importDefault(require("../nodes/element/DOMRectReadOnly.cjs"));
const VMGlobalPropertyScript_js_1 = __importDefault(require("./VMGlobalPropertyScript.cjs"));
const vm_1 = __importDefault(require("vm"));
const buffer_1 = require("buffer");
const crypto_1 = require("crypto");
const XMLHttpRequestUpload_js_1 = __importDefault(require("../xml-http-request/XMLHttpRequestUpload.cjs"));
const XMLHttpRequestEventTarget_js_1 = __importDefault(require("../xml-http-request/XMLHttpRequestEventTarget.cjs"));
const Base64_js_1 = __importDefault(require("../base64/Base64.cjs"));
const Attr_js_1 = __importDefault(require("../nodes/attr/Attr.cjs"));
const NamedNodeMap_js_1 = __importDefault(require("../named-node-map/NamedNodeMap.cjs"));
const Element_js_1 = __importDefault(require("../nodes/element/Element.cjs"));
const ProcessingInstruction_js_1 = __importDefault(require("../nodes/processing-instruction/ProcessingInstruction.cjs"));
const FileList_js_1 = __importDefault(require("../nodes/html-input-element/FileList.cjs"));
const stream_1 = __importDefault(require("stream"));
const web_1 = require("stream/web");
const FormData_js_1 = __importDefault(require("../form-data/FormData.cjs"));
const AbortController_js_1 = __importDefault(require("../fetch/AbortController.cjs"));
const AbortSignal_js_1 = __importDefault(require("../fetch/AbortSignal.cjs"));
const DOMExceptionNameEnum_js_1 = __importDefault(require("../exception/DOMExceptionNameEnum.cjs"));
const RadioNodeList_js_1 = __importDefault(require("../nodes/html-form-element/RadioNodeList.cjs"));
const ValidityState_js_1 = __importDefault(require("../validity-state/ValidityState.cjs"));
const WindowErrorUtility_js_1 = __importDefault(require("./WindowErrorUtility.cjs"));
const Permissions_js_1 = __importDefault(require("../permissions/Permissions.cjs"));
const PermissionStatus_js_1 = __importDefault(require("../permissions/PermissionStatus.cjs"));
const Clipboard_js_1 = __importDefault(require("../clipboard/Clipboard.cjs"));
const ClipboardItem_js_1 = __importDefault(require("../clipboard/ClipboardItem.cjs"));
const ClipboardEvent_js_1 = __importDefault(require("../event/events/ClipboardEvent.cjs"));
const Headers_js_1 = __importDefault(require("../fetch/Headers.cjs"));
const XMLHttpRequest_js_1 = __importDefault(require("../xml-http-request/XMLHttpRequest.cjs"));
const WindowBrowserSettingsReader_js_1 = __importDefault(require("./WindowBrowserSettingsReader.cjs"));
const DocumentReadyStateManager_js_1 = __importDefault(require("../nodes/document/DocumentReadyStateManager.cjs"));
const DocumentReadyStateEnum_js_1 = __importDefault(require("../nodes/document/DocumentReadyStateEnum.cjs"));
const HTMLAnchorElement_js_1 = __importDefault(require("../nodes/html-anchor-element/HTMLAnchorElement.cjs"));
const HTMLButtonElement_js_1 = __importDefault(require("../nodes/html-button-element/HTMLButtonElement.cjs"));
const HTMLOptionElement_js_1 = __importDefault(require("../nodes/html-option-element/HTMLOptionElement.cjs"));
const HTMLOptGroupElement_js_1 = __importDefault(require("../nodes/html-opt-group-element/HTMLOptGroupElement.cjs"));
const HTMLTimeElement_js_1 = __importDefault(require("../nodes/html-time-element/HTMLTimeElement.cjs"));
const WindowPageOpenUtility_js_1 = __importDefault(require("./WindowPageOpenUtility.cjs"));
const BrowserErrorCaptureEnum_js_1 = __importDefault(require("../browser/enums/BrowserErrorCaptureEnum.cjs"));
const Audio_js_1 = __importDefault(require("../nodes/html-audio-element/Audio.cjs"));
const Image_js_1 = __importDefault(require("../nodes/html-image-element/Image.cjs"));
const Text_js_1 = __importDefault(require("../nodes/text/Text.cjs"));
const Comment_js_1 = __importDefault(require("../nodes/comment/Comment.cjs"));
const DocumentFragment_js_1 = __importDefault(require("../nodes/document-fragment/DocumentFragment.cjs"));
const DOMParser_js_1 = __importDefault(require("../dom-parser/DOMParser.cjs"));
const FileReader_js_1 = __importDefault(require("../file/FileReader.cjs"));
const Request_js_1 = __importDefault(require("../fetch/Request.cjs"));
const Response_js_1 = __importDefault(require("../fetch/Response.cjs"));
const Range_js_1 = __importDefault(require("../range/Range.cjs"));
const TIMER = {
    setTimeout: globalThis.setTimeout.bind(globalThis),
    clearTimeout: globalThis.clearTimeout.bind(globalThis),
    setInterval: globalThis.setInterval.bind(globalThis),
    clearInterval: globalThis.clearInterval.bind(globalThis),
    queueMicrotask: globalThis.queueMicrotask.bind(globalThis),
    setImmediate: globalThis.setImmediate.bind(globalThis),
    clearImmediate: globalThis.clearImmediate.bind(globalThis)
};
const IS_NODE_JS_TIMEOUT_ENVIRONMENT = setTimeout.toString().includes('new Timeout');
/**
 * Zero Timeout.
 */
class Timeout {
    /**
     * Constructor.
     * @param callback Callback.
     */
    constructor(callback) {
        this.callback = callback;
    }
}
/**
 * Browser window.
 *
 * Reference:
 * https://developer.mozilla.org/en-US/docs/Web/API/Window.
 */
class BrowserWindow extends EventTarget_js_1.default {
    /**
     * Constructor.
     *
     * @param browserFrame Browser frame.
     * @param [options] Options.
     * @param [options.url] URL.
     */
    constructor(browserFrame, options) {
        var _f;
        super();
        _BrowserWindow_instances.add(this);
        // Nodes
        this.Node = Node_js_1.default;
        this.Attr = Attr_js_1.default;
        this.SVGSVGElement = SVGSVGElement_js_1.default;
        this.SVGElement = SVGElement_js_1.default;
        this.SVGGraphicsElement = SVGGraphicsElement_js_1.default;
        this.ShadowRoot = ShadowRoot_js_1.default;
        this.ProcessingInstruction = ProcessingInstruction_js_1.default;
        this.Element = Element_js_1.default;
        this.CharacterData = CharacterData_js_1.default;
        this.DocumentType = DocumentType_js_1.default;
        // Element classes
        this.HTMLAnchorElement = HTMLAnchorElement_js_1.default;
        this.HTMLButtonElement = HTMLButtonElement_js_1.default;
        this.HTMLOptGroupElement = HTMLOptGroupElement_js_1.default;
        this.HTMLOptionElement = HTMLOptionElement_js_1.default;
        this.HTMLElement = HTMLElement_js_1.default;
        this.HTMLUnknownElement = HTMLUnknownElement_js_1.default;
        this.HTMLTemplateElement = HTMLTemplateElement_js_1.default;
        this.HTMLInputElement = HTMLInputElement_js_1.default;
        this.HTMLSelectElement = HTMLSelectElement_js_1.default;
        this.HTMLTextAreaElement = HTMLTextAreaElement_js_1.default;
        this.HTMLImageElement = HTMLImageElement_js_1.default;
        this.HTMLStyleElement = HTMLStyleElement_js_1.default;
        this.HTMLLabelElement = HTMLLabelElement_js_1.default;
        this.HTMLSlotElement = HTMLSlotElement_js_1.default;
        this.HTMLMetaElement = HTMLMetaElement_js_1.default;
        this.HTMLMediaElement = HTMLMediaElement_js_1.default;
        this.HTMLAudioElement = HTMLAudioElement_js_1.default;
        this.HTMLVideoElement = HTMLVideoElement_js_1.default;
        this.HTMLBaseElement = HTMLBaseElement_js_1.default;
        this.HTMLDialogElement = HTMLDialogElement_js_1.default;
        this.HTMLTimeElement = HTMLTimeElement_js_1.default;
        // Non-implemented element classes
        this.HTMLHeadElement = HTMLElement_js_1.default;
        this.HTMLTitleElement = HTMLElement_js_1.default;
        this.HTMLBodyElement = HTMLElement_js_1.default;
        this.HTMLHeadingElement = HTMLElement_js_1.default;
        this.HTMLParagraphElement = HTMLElement_js_1.default;
        this.HTMLHRElement = HTMLElement_js_1.default;
        this.HTMLPreElement = HTMLElement_js_1.default;
        this.HTMLUListElement = HTMLElement_js_1.default;
        this.HTMLOListElement = HTMLElement_js_1.default;
        this.HTMLLElement = HTMLElement_js_1.default;
        this.HTMLMenuElement = HTMLElement_js_1.default;
        this.HTMLDListElement = HTMLElement_js_1.default;
        this.HTMLDivElement = HTMLElement_js_1.default;
        this.HTMLAreaElement = HTMLElement_js_1.default;
        this.HTMLBRElement = HTMLElement_js_1.default;
        this.HTMLCanvasElement = HTMLElement_js_1.default;
        this.HTMLDataElement = HTMLElement_js_1.default;
        this.HTMLDataListElement = HTMLElement_js_1.default;
        this.HTMLDetailsElement = HTMLElement_js_1.default;
        this.HTMLDirectoryElement = HTMLElement_js_1.default;
        this.HTMLFieldSetElement = HTMLElement_js_1.default;
        this.HTMLFontElement = HTMLElement_js_1.default;
        this.HTMLHtmlElement = HTMLElement_js_1.default;
        this.HTMLLegendElement = HTMLElement_js_1.default;
        this.HTMLMapElement = HTMLElement_js_1.default;
        this.HTMLMarqueeElement = HTMLElement_js_1.default;
        this.HTMLMeterElement = HTMLElement_js_1.default;
        this.HTMLModElement = HTMLElement_js_1.default;
        this.HTMLOutputElement = HTMLElement_js_1.default;
        this.HTMLPictureElement = HTMLElement_js_1.default;
        this.HTMLProgressElement = HTMLElement_js_1.default;
        this.HTMLQuoteElement = HTMLElement_js_1.default;
        this.HTMLSourceElement = HTMLElement_js_1.default;
        this.HTMLSpanElement = HTMLElement_js_1.default;
        this.HTMLTableCaptionElement = HTMLElement_js_1.default;
        this.HTMLTableCellElement = HTMLElement_js_1.default;
        this.HTMLTableColElement = HTMLElement_js_1.default;
        this.HTMLTableElement = HTMLElement_js_1.default;
        this.HTMLTableRowElement = HTMLElement_js_1.default;
        this.HTMLTableSectionElement = HTMLElement_js_1.default;
        this.HTMLFrameElement = HTMLElement_js_1.default;
        this.HTMLFrameSetElement = HTMLElement_js_1.default;
        this.HTMLEmbedElement = HTMLElement_js_1.default;
        this.HTMLObjectElement = HTMLElement_js_1.default;
        this.HTMLParamElement = HTMLElement_js_1.default;
        this.HTMLTrackElement = HTMLElement_js_1.default;
        // Event classes
        this.Event = Event_js_1.default;
        this.UIEvent = UIEvent_js_1.default;
        this.CustomEvent = CustomEvent_js_1.default;
        this.AnimationEvent = AnimationEvent_js_1.default;
        this.KeyboardEvent = KeyboardEvent_js_1.default;
        this.MessageEvent = MessageEvent_js_1.default;
        this.MouseEvent = MouseEvent_js_1.default;
        this.PointerEvent = PointerEvent_js_1.default;
        this.FocusEvent = FocusEvent_js_1.default;
        this.WheelEvent = WheelEvent_js_1.default;
        this.InputEvent = InputEvent_js_1.default;
        this.ErrorEvent = ErrorEvent_js_1.default;
        this.StorageEvent = StorageEvent_js_1.default;
        this.SubmitEvent = SubmitEvent_js_1.default;
        this.ProgressEvent = ProgressEvent_js_1.default;
        this.MediaQueryListEvent = MediaQueryListEvent_js_1.default;
        this.HashChangeEvent = HashChangeEvent_js_1.default;
        this.ClipboardEvent = ClipboardEvent_js_1.default;
        this.TouchEvent = TouchEvent_js_1.default;
        this.Touch = Touch_js_1.default;
        // Non-implemented event classes
        this.AudioProcessingEvent = Event_js_1.default;
        this.BeforeInputEvent = Event_js_1.default;
        this.BeforeUnloadEvent = Event_js_1.default;
        this.BlobEvent = Event_js_1.default;
        this.CloseEvent = Event_js_1.default;
        this.CompositionEvent = Event_js_1.default;
        this.CSSFontFaceLoadEvent = Event_js_1.default;
        this.DeviceLightEvent = Event_js_1.default;
        this.DeviceMotionEvent = Event_js_1.default;
        this.DeviceOrientationEvent = Event_js_1.default;
        this.DeviceProximityEvent = Event_js_1.default;
        this.DOMTransactionEvent = Event_js_1.default;
        this.DragEvent = Event_js_1.default;
        this.EditingBeforeInputEvent = Event_js_1.default;
        this.FetchEvent = Event_js_1.default;
        this.GamepadEvent = Event_js_1.default;
        this.IDBVersionChangeEvent = Event_js_1.default;
        this.MediaStreamEvent = Event_js_1.default;
        this.MutationEvent = Event_js_1.default;
        this.OfflineAudioCompletionEvent = Event_js_1.default;
        this.OverconstrainedError = Event_js_1.default;
        this.PageTransitionEvent = Event_js_1.default;
        this.PaymentRequestUpdateEvent = Event_js_1.default;
        this.PopStateEvent = Event_js_1.default;
        this.RelatedEvent = Event_js_1.default;
        this.RTCDataChannelEvent = Event_js_1.default;
        this.RTCIdentityErrorEvent = Event_js_1.default;
        this.RTCIdentityEvent = Event_js_1.default;
        this.RTCPeerConnectionIceEvent = Event_js_1.default;
        this.SensorEvent = Event_js_1.default;
        this.SVGEvent = Event_js_1.default;
        this.SVGZoomEvent = Event_js_1.default;
        this.TimeEvent = Event_js_1.default;
        this.TrackEvent = Event_js_1.default;
        this.TransitionEvent = Event_js_1.default;
        this.UserProximityEvent = Event_js_1.default;
        this.WebGLContextEvent = Event_js_1.default;
        this.TextEvent = Event_js_1.default;
        // Other classes
        this.NamedNodeMap = NamedNodeMap_js_1.default;
        this.NodeFilter = NodeFilter_js_1.default;
        this.NodeIterator = NodeIterator_js_1.default;
        this.TreeWalker = TreeWalker_js_1.default;
        this.MutationObserver = MutationObserver_js_1.default;
        this.MutationRecord = MutationRecord_js_1.default;
        this.CSSStyleDeclaration = CSSStyleDeclaration_js_1.default;
        this.EventTarget = EventTarget_js_1.default;
        this.MessagePort = MessagePort_js_1.default;
        this.DataTransfer = DataTransfer_js_1.default;
        this.DataTransferItem = DataTransferItem_js_1.default;
        this.DataTransferItemList = DataTransferItemList_js_1.default;
        this.URL = URL_js_1.default;
        this.Location = Location_js_1.default;
        this.CustomElementRegistry = CustomElementRegistry_js_1.default;
        this.Window = this.constructor;
        this.XMLSerializer = XMLSerializer_js_1.default;
        this.ResizeObserver = ResizeObserver_js_1.default;
        this.CSSStyleSheet = CSSStyleSheet_js_1.default;
        this.Blob = Blob_js_1.default;
        this.File = File_js_1.default;
        this.DOMException = DOMException_js_1.default;
        this.History = History_js_1.default;
        this.Screen = Screen_js_1.default;
        this.Storage = Storage_js_1.default;
        this.URLSearchParams = url_1.URLSearchParams;
        this.HTMLCollection = HTMLCollection_js_1.default;
        this.HTMLFormControlsCollection = HTMLFormControlsCollection_js_1.default;
        this.NodeList = NodeList_js_1.default;
        this.CSSUnitValue = CSSUnitValue_js_1.default;
        this.CSSRule = CSSRule_js_1.default;
        this.CSSContainerRule = CSSContainerRule_js_1.default;
        this.CSSFontFaceRule = CSSFontFaceRule_js_1.default;
        this.CSSKeyframeRule = CSSKeyframeRule_js_1.default;
        this.CSSKeyframesRule = CSSKeyframesRule_js_1.default;
        this.CSSMediaRule = CSSMediaRule_js_1.default;
        this.CSSStyleRule = CSSStyleRule_js_1.default;
        this.CSSSupportsRule = CSSSupportsRule_js_1.default;
        this.Selection = Selection_js_1.default;
        this.Navigator = Navigator_js_1.default;
        this.MimeType = MimeType_js_1.default;
        this.MimeTypeArray = MimeTypeArray_js_1.default;
        this.Plugin = Plugin_js_1.default;
        this.PluginArray = PluginArray_js_1.default;
        this.FileList = FileList_js_1.default;
        this.DOMRect = DOMRect_js_1.default;
        this.DOMRectReadOnly = DOMRectReadOnly_js_1.default;
        this.RadioNodeList = RadioNodeList_js_1.default;
        this.ValidityState = ValidityState_js_1.default;
        this.Headers = Headers_js_1.default;
        this.XMLHttpRequestUpload = XMLHttpRequestUpload_js_1.default;
        this.XMLHttpRequestEventTarget = XMLHttpRequestEventTarget_js_1.default;
        this.ReadableStream = web_1.ReadableStream;
        this.WritableStream = stream_1.default.Writable;
        this.TransformStream = stream_1.default.Transform;
        this.AbortController = AbortController_js_1.default;
        this.AbortSignal = AbortSignal_js_1.default;
        this.FormData = FormData_js_1.default;
        this.Permissions = Permissions_js_1.default;
        this.PermissionStatus = PermissionStatus_js_1.default;
        this.Clipboard = Clipboard_js_1.default;
        this.ClipboardItem = ClipboardItem_js_1.default;
        // Events
        this.onload = null;
        this.onerror = null;
        this.self = this;
        this.top = this;
        this.parent = this;
        this.window = this;
        this.globalThis = this;
        this.performance = performance;
        this.screenLeft = 0;
        this.screenTop = 0;
        this.screenX = 0;
        this.screenY = 0;
        this.crypto = crypto_1.webcrypto;
        this.closed = false;
        this.name = '';
        this.Buffer = buffer_1.Buffer;
        // Public internal properties
        // Used for tracking capture event listeners to improve performance when they are not used.
        // See EventTarget class.
        this[_b] = {};
        this[_c] = [];
        this[_d] = new DocumentReadyStateManager_js_1.default(this);
        this[_e] = null;
        // Private properties
        _BrowserWindow_browserFrame.set(this, void 0);
        _BrowserWindow_innerWidth.set(this, null);
        _BrowserWindow_innerHeight.set(this, null);
        _BrowserWindow_outerWidth.set(this, null);
        _BrowserWindow_outerHeight.set(this, null);
        _BrowserWindow_devicePixelRatio.set(this, null);
        _BrowserWindow_zeroTimeouts.set(this, null);
        const asyncTaskManager = browserFrame[PropertySymbol.asyncTaskManager];
        __classPrivateFieldSet(this, _BrowserWindow_browserFrame, browserFrame, "f");
        this.customElements = new CustomElementRegistry_js_1.default(this);
        this[PropertySymbol.navigator] = new Navigator_js_1.default(this);
        this[PropertySymbol.history] = new History_js_1.default();
        this[PropertySymbol.screen] = new Screen_js_1.default();
        this[PropertySymbol.sessionStorage] = StorageFactory_js_1.default.createStorage();
        this[PropertySymbol.localStorage] = StorageFactory_js_1.default.createStorage();
        this[PropertySymbol.location] = new Location_js_1.default(__classPrivateFieldGet(this, _BrowserWindow_browserFrame, "f"), options?.url ?? 'about:blank');
        this[PropertySymbol.asyncTaskManager] = asyncTaskManager;
        this.console = browserFrame.page.console;
        WindowBrowserSettingsReader_js_1.default.setSettings(this, __classPrivateFieldGet(this, _BrowserWindow_browserFrame, "f").page.context.browser.settings);
        const window = this;
        this[PropertySymbol.setupVMContext]();
        // Class overrides
        // For classes that need to be bound to the correct context.
        /* eslint-disable jsdoc/require-jsdoc */
        class Request extends Request_js_1.default {
            constructor(input, init) {
                super({ window, asyncTaskManager }, input, init);
            }
        }
        class Response extends Response_js_1.default {
            constructor(body, init) {
                super({ window, browserFrame }, body, init);
            }
        }
        _f = PropertySymbol.window;
        Response[_f] = window;
        class XMLHttpRequest extends XMLHttpRequest_js_1.default {
            constructor() {
                super({ window, browserFrame });
            }
        }
        class FileReader extends FileReader_js_1.default {
            constructor() {
                super(window);
            }
        }
        class DOMParser extends DOMParser_js_1.default {
            constructor() {
                super(window);
            }
        }
        class Range extends Range_js_1.default {
            constructor() {
                super(window);
            }
        }
        class HTMLScriptElement extends HTMLScriptElement_js_1.default {
            constructor() {
                super(browserFrame);
            }
        }
        class HTMLLinkElement extends HTMLLinkElement_js_1.default {
            constructor() {
                super(browserFrame);
            }
        }
        class HTMLIFrameElement extends HTMLIFrameElement_js_1.default {
            constructor() {
                super(browserFrame);
            }
        }
        class HTMLFormElement extends HTMLFormElement_js_1.default {
            constructor() {
                super(browserFrame);
            }
        }
        class Document extends Document_js_1.default {
            constructor() {
                super({ window, browserFrame });
            }
        }
        class HTMLDocument extends HTMLDocument_js_1.default {
            constructor() {
                super({ window, browserFrame });
            }
        }
        class XMLDocument extends XMLDocument_js_1.default {
            constructor() {
                super({ window, browserFrame });
            }
        }
        class SVGDocument extends SVGDocument_js_1.default {
            constructor() {
                super({ window, browserFrame });
            }
        }
        class Audio extends Audio_js_1.default {
        }
        class Image extends Image_js_1.default {
        }
        class DocumentFragment extends DocumentFragment_js_1.default {
        }
        class Text extends Text_js_1.default {
        }
        class Comment extends Comment_js_1.default {
        }
        /* eslint-enable jsdoc/require-jsdoc */
        this.Response = Response;
        this.Request = Request;
        this.Image = Image;
        this.Text = Text;
        this.Comment = Comment;
        this.DocumentFragment = DocumentFragment;
        this.FileReader = FileReader;
        this.DOMParser = DOMParser;
        this.XMLHttpRequest = XMLHttpRequest;
        this.Range = Range;
        this.Audio = Audio;
        this.HTMLScriptElement = HTMLScriptElement;
        this.HTMLLinkElement = HTMLLinkElement;
        this.HTMLIFrameElement = HTMLIFrameElement;
        this.HTMLFormElement = HTMLFormElement;
        this.Document = Document;
        this.HTMLDocument = HTMLDocument;
        this.XMLDocument = XMLDocument;
        this.SVGDocument = SVGDocument;
        // Override owner document
        this.Document[PropertySymbol.ownerDocument] = null;
        this.HTMLDocument[PropertySymbol.ownerDocument] = null;
        this.XMLDocument[PropertySymbol.ownerDocument] = null;
        this.SVGDocument[PropertySymbol.ownerDocument] = null;
        // Document
        this.document = new HTMLDocument();
        this.document[PropertySymbol.defaultView] = this;
        // Override owner document
        this.Audio[PropertySymbol.ownerDocument] = this.document;
        this.Image[PropertySymbol.ownerDocument] = this.document;
        this.DocumentFragment[PropertySymbol.ownerDocument] = this.document;
        this.Text[PropertySymbol.ownerDocument] = this.document;
        this.Comment[PropertySymbol.ownerDocument] = this.document;
        // Ready state manager
        this[PropertySymbol.readyStateManager].waitUntilComplete().then(() => {
            this.document[PropertySymbol.readyState] = DocumentReadyStateEnum_js_1.default.complete;
            this.document.dispatchEvent(new Event_js_1.default('readystatechange'));
            this.document.dispatchEvent(new Event_js_1.default('load', { bubbles: true }));
        });
        __classPrivateFieldGet(this, _BrowserWindow_instances, "m", _BrowserWindow_bindToThisScope).call(this);
    }
    /**
     * Returns location.
     */
    get location() {
        return this[PropertySymbol.location];
    }
    /**
     * Returns location.
     *
     * @param href Href.
     */
    set location(href) {
        this[PropertySymbol.location].href = href;
    }
    /**
     * Returns history.
     */
    get history() {
        return this[PropertySymbol.history];
    }
    /**
     * Returns navigator.
     */
    get navigator() {
        return this[PropertySymbol.navigator];
    }
    /**
     * Returns screen.
     */
    get screen() {
        return this[PropertySymbol.screen];
    }
    /**
     * Returns session storage.
     */
    get sessionStorage() {
        return this[PropertySymbol.sessionStorage];
    }
    /**
     * Returns local storage.
     */
    get localStorage() {
        return this[PropertySymbol.localStorage];
    }
    /**
     * Returns opener.
     *
     * @returns Opener.
     */
    get opener() {
        return __classPrivateFieldGet(this, _BrowserWindow_browserFrame, "f")[PropertySymbol.openerWindow];
    }
    /**
     * The number of pixels that the document is currently scrolled horizontally.
     *
     * @returns Scroll X.
     */
    get scrollX() {
        return this.document?.documentElement?.scrollLeft ?? 0;
    }
    /**
     * The read-only Window property pageXOffset is an alias for scrollX.
     *
     * @returns Scroll X.
     */
    get pageXOffset() {
        return this.scrollX;
    }
    /**
     * The number of pixels that the document is currently scrolled vertically.
     *
     * @returns Scroll Y.
     */
    get scrollY() {
        return this.document?.documentElement?.scrollTop ?? 0;
    }
    /**
     * The read-only Window property pageYOffset is an alias for scrollY.
     *
     * @returns Scroll Y.
     */
    get pageYOffset() {
        return this.scrollY;
    }
    /**
     * The CSS interface holds useful CSS-related methods.
     *
     * @returns CSS interface.
     */
    get CSS() {
        return new CSS_js_1.default();
    }
    /**
     * Returns inner width.
     *
     * @returns Inner width.
     */
    get innerWidth() {
        if (__classPrivateFieldGet(this, _BrowserWindow_innerWidth, "f") === null) {
            return __classPrivateFieldGet(this, _BrowserWindow_browserFrame, "f").page.viewport.width;
        }
        return __classPrivateFieldGet(this, _BrowserWindow_innerWidth, "f");
    }
    /**
     * Sets inner width.
     *
     * @param value Inner width.
     */
    set innerWidth(value) {
        __classPrivateFieldSet(this, _BrowserWindow_innerWidth, value, "f");
    }
    /**
     * Returns inner height.
     *
     * @returns Inner height.
     */
    get innerHeight() {
        // It seems like this value can be defined according to spec, but changing it has no effect on the actual viewport.
        if (__classPrivateFieldGet(this, _BrowserWindow_innerHeight, "f") === null) {
            return __classPrivateFieldGet(this, _BrowserWindow_browserFrame, "f").page.viewport.height;
        }
        return __classPrivateFieldGet(this, _BrowserWindow_innerHeight, "f");
    }
    /**
     * Sets inner height.
     *
     * @param value Inner height.
     */
    set innerHeight(value) {
        __classPrivateFieldSet(this, _BrowserWindow_innerHeight, value, "f");
    }
    /**
     * Returns outer width.
     *
     * @returns Outer width.
     */
    get outerWidth() {
        // It seems like this value can be defined according to spec, but changing it has no effect on the actual viewport.
        if (__classPrivateFieldGet(this, _BrowserWindow_outerWidth, "f") === null) {
            return __classPrivateFieldGet(this, _BrowserWindow_browserFrame, "f").page.viewport.width;
        }
        return __classPrivateFieldGet(this, _BrowserWindow_outerWidth, "f");
    }
    /**
     * Sets outer width.
     *
     * @param value Outer width.
     */
    set outerWidth(value) {
        __classPrivateFieldSet(this, _BrowserWindow_outerWidth, value, "f");
    }
    /**
     * Returns outer height.
     *
     * @returns Outer height.
     */
    get outerHeight() {
        if (__classPrivateFieldGet(this, _BrowserWindow_outerHeight, "f") === null) {
            return __classPrivateFieldGet(this, _BrowserWindow_browserFrame, "f").page.viewport.height;
        }
        return __classPrivateFieldGet(this, _BrowserWindow_outerHeight, "f");
    }
    /**
     * Sets outer height.
     *
     * @param value Outer height.
     */
    set outerHeight(value) {
        __classPrivateFieldSet(this, _BrowserWindow_outerHeight, value, "f");
    }
    /**
     * Returns device pixel ratio.
     *
     * @returns Device pixel ratio.
     */
    get devicePixelRatio() {
        // It seems like this value can be defined according to spec, but changing it has no effect on the actual viewport.
        if (__classPrivateFieldGet(this, _BrowserWindow_devicePixelRatio, "f") === null) {
            return __classPrivateFieldGet(this, _BrowserWindow_browserFrame, "f").page.viewport.devicePixelRatio;
        }
        return __classPrivateFieldGet(this, _BrowserWindow_devicePixelRatio, "f");
    }
    /**
     * Sets device pixel ratio.
     *
     * @param value Device pixel ratio.
     */
    set devicePixelRatio(value) {
        __classPrivateFieldSet(this, _BrowserWindow_devicePixelRatio, value, "f");
    }
    /**
     * Returns an object containing the values of all CSS properties of an element.
     *
     * @param element Element.
     * @returns CSS style declaration.
     */
    getComputedStyle(element) {
        element[PropertySymbol.computedStyle] =
            element[PropertySymbol.computedStyle] || new CSSStyleDeclaration_js_1.default(element, true);
        return element[PropertySymbol.computedStyle];
    }
    /**
     * Returns selection.
     *
     * @returns Selection.
     */
    getSelection() {
        return this.document.getSelection();
    }
    /**
     * Scrolls to a particular set of coordinates.
     *
     * @param x X position or options object.
     * @param y Y position.
     */
    scroll(x, y) {
        if (typeof x === 'object') {
            if (x.behavior === 'smooth') {
                this.setTimeout(() => {
                    if (x.top !== undefined) {
                        this.document.documentElement.scrollTop = x.top;
                    }
                    if (x.left !== undefined) {
                        this.document.documentElement.scrollLeft = x.left;
                    }
                });
            }
            else {
                if (x.top !== undefined) {
                    this.document.documentElement.scrollTop = x.top;
                }
                if (x.left !== undefined) {
                    this.document.documentElement.scrollLeft = x.left;
                }
            }
        }
        else if (x !== undefined && y !== undefined) {
            this.document.documentElement.scrollLeft = x;
            this.document.documentElement.scrollTop = y;
        }
    }
    /**
     * Scrolls to a particular set of coordinates.
     *
     * @param x X position or options object.
     * @param y Y position.
     */
    scrollTo(x, y) {
        this.scroll(x, y);
    }
    /**
     * Shifts focus away from the window.
     */
    blur() {
        // TODO: Implement.
    }
    /**
     * Gives focus to the window.
     */
    focus() {
        // TODO: Implement.
    }
    /**
     * Loads a specified resource into a new or existing browsing context (that is, a tab, a window, or an iframe) under a specified name.
     *
     * @param [url] URL.
     * @param [target] Target.
     * @param [features] Window features.
     * @returns Window.
     */
    open(url, target, features) {
        return WindowPageOpenUtility_js_1.default.openPage(__classPrivateFieldGet(this, _BrowserWindow_browserFrame, "f"), {
            url,
            target,
            features
        });
    }
    /**
     * Closes the window.
     */
    close() {
        // When using a Window instance directly, the Window instance is the main frame and we will close the page and destroy the browser.
        // When using the Browser API we should only close the page when the Window instance is connected to the main frame (we should not close child frames such as iframes).
        if (__classPrivateFieldGet(this, _BrowserWindow_browserFrame, "f").page?.mainFrame === __classPrivateFieldGet(this, _BrowserWindow_browserFrame, "f")) {
            this[PropertySymbol.destroy]();
            __classPrivateFieldGet(this, _BrowserWindow_browserFrame, "f").page.close();
        }
    }
    /**
     * Returns a new MediaQueryList object that can then be used to determine if the document matches the media query string.
     *
     * @param mediaQueryString A string specifying the media query to parse into a MediaQueryList.
     * @returns A new MediaQueryList.
     */
    matchMedia(mediaQueryString) {
        return new MediaQueryList_js_1.default({ ownerWindow: this, media: mediaQueryString });
    }
    /**
     * Sets a timer which executes a function once the timer expires.
     *
     * @param callback Function to be executed.
     * @param [delay=0] Delay in ms.
     * @param args Arguments passed to the callback function.
     * @returns Timeout ID.
     */
    setTimeout(callback, delay = 0, ...args) {
        // We can group timeouts with a delay of 0 into one timeout to improve performance.
        // Grouping timeouts will also improve the performance of the async task manager.
        // It may also make the async task manager to stable as many timeouts may cause waitUntilComplete() to be resolved to early.
        if (!delay) {
            if (!__classPrivateFieldGet(this, _BrowserWindow_zeroTimeouts, "f")) {
                const settings = __classPrivateFieldGet(this, _BrowserWindow_browserFrame, "f").page?.context?.browser?.settings;
                const useTryCatch = !settings ||
                    !settings.disableErrorCapturing ||
                    settings.errorCapture === BrowserErrorCaptureEnum_js_1.default.tryAndCatch;
                const id = TIMER.setTimeout(() => {
                    const zeroTimeouts = __classPrivateFieldGet(this, _BrowserWindow_zeroTimeouts, "f");
                    __classPrivateFieldSet(this, _BrowserWindow_zeroTimeouts, null, "f");
                    for (const zeroTimeout of zeroTimeouts) {
                        if (useTryCatch) {
                            WindowErrorUtility_js_1.default.captureError(this, () => zeroTimeout.callback());
                        }
                        else {
                            zeroTimeout.callback();
                        }
                    }
                    __classPrivateFieldGet(this, _BrowserWindow_browserFrame, "f")[PropertySymbol.asyncTaskManager].endTimer(id);
                });
                __classPrivateFieldSet(this, _BrowserWindow_zeroTimeouts, [], "f");
                __classPrivateFieldGet(this, _BrowserWindow_browserFrame, "f")[PropertySymbol.asyncTaskManager].startTimer(id);
            }
            const zeroTimeout = new Timeout(() => callback(...args));
            __classPrivateFieldGet(this, _BrowserWindow_zeroTimeouts, "f").push(zeroTimeout);
            return zeroTimeout;
        }
        const settings = __classPrivateFieldGet(this, _BrowserWindow_browserFrame, "f").page?.context?.browser?.settings;
        const useTryCatch = !settings ||
            !settings.disableErrorCapturing ||
            settings.errorCapture === BrowserErrorCaptureEnum_js_1.default.tryAndCatch;
        const id = TIMER.setTimeout(() => {
            if (useTryCatch) {
                WindowErrorUtility_js_1.default.captureError(this, () => callback(...args));
            }
            else {
                callback(...args);
            }
            __classPrivateFieldGet(this, _BrowserWindow_browserFrame, "f")[PropertySymbol.asyncTaskManager].endTimer(id);
        }, settings?.timer.maxTimeout !== -1 && delay && delay > settings?.timer.maxTimeout
            ? settings?.timer.maxTimeout
            : delay);
        __classPrivateFieldGet(this, _BrowserWindow_browserFrame, "f")[PropertySymbol.asyncTaskManager].startTimer(id);
        return id;
    }
    /**
     * Cancels a timeout previously established by calling setTimeout().
     *
     * @param id ID of the timeout.
     */
    clearTimeout(id) {
        if (id && id instanceof Timeout) {
            const zeroTimeouts = __classPrivateFieldGet(this, _BrowserWindow_zeroTimeouts, "f") || [];
            const index = zeroTimeouts.indexOf(id);
            if (index !== -1) {
                zeroTimeouts.splice(index, 1);
            }
            return;
        }
        // We need to make sure that the ID is a Timeout object, otherwise Node.js might throw an error.
        // This is only necessary if we are in a Node.js environment.
        if (IS_NODE_JS_TIMEOUT_ENVIRONMENT && (!id || id.constructor.name !== 'Timeout')) {
            return;
        }
        TIMER.clearTimeout(id);
        __classPrivateFieldGet(this, _BrowserWindow_browserFrame, "f")[PropertySymbol.asyncTaskManager].endTimer(id);
    }
    /**
     * Calls a function with a fixed time delay between each call.
     *
     * @param callback Function to be executed.
     * @param [delay=0] Delay in ms.
     * @param args Arguments passed to the callback function.
     * @returns Interval ID.
     */
    setInterval(callback, delay = 0, ...args) {
        const settings = __classPrivateFieldGet(this, _BrowserWindow_browserFrame, "f").page?.context?.browser?.settings;
        const useTryCatch = !settings ||
            !settings.disableErrorCapturing ||
            settings.errorCapture === BrowserErrorCaptureEnum_js_1.default.tryAndCatch;
        let iterations = 0;
        const id = TIMER.setInterval(() => {
            if (useTryCatch) {
                WindowErrorUtility_js_1.default.captureError(this, () => callback(...args), () => this.clearInterval(id));
            }
            else {
                callback(...args);
            }
            if (settings?.timer.maxIntervalIterations !== -1) {
                if (iterations >= settings?.timer.maxIntervalIterations) {
                    this.clearInterval(id);
                }
                iterations++;
            }
        }, settings?.timer.maxIntervalTime !== -1 && delay && delay > settings?.timer.maxIntervalTime
            ? settings?.timer.maxIntervalTime
            : delay);
        __classPrivateFieldGet(this, _BrowserWindow_browserFrame, "f")[PropertySymbol.asyncTaskManager].startTimer(id);
        return id;
    }
    /**
     * Cancels a timed repeating action which was previously established by a call to setInterval().
     *
     * @param id ID of the interval.
     */
    clearInterval(id) {
        // We need to make sure that the ID is a Timeout object, otherwise Node.js might throw an error.
        // This is only necessary if we are in a Node.js environment.
        if (IS_NODE_JS_TIMEOUT_ENVIRONMENT && (!id || id.constructor.name !== 'Timeout')) {
            return;
        }
        TIMER.clearInterval(id);
        __classPrivateFieldGet(this, _BrowserWindow_browserFrame, "f")[PropertySymbol.asyncTaskManager].endTimer(id);
    }
    /**
     * Mock animation frames with timeouts.
     *
     * @param callback Callback.
     * @returns ID.
     */
    requestAnimationFrame(callback) {
        const settings = __classPrivateFieldGet(this, _BrowserWindow_browserFrame, "f").page?.context?.browser?.settings;
        const useTryCatch = !settings ||
            !settings.disableErrorCapturing ||
            settings.errorCapture === BrowserErrorCaptureEnum_js_1.default.tryAndCatch;
        const id = TIMER.setImmediate(() => {
            if (useTryCatch) {
                WindowErrorUtility_js_1.default.captureError(this, () => callback(this.performance.now()));
            }
            else {
                callback(this.performance.now());
            }
            __classPrivateFieldGet(this, _BrowserWindow_browserFrame, "f")[PropertySymbol.asyncTaskManager].endImmediate(id);
        });
        __classPrivateFieldGet(this, _BrowserWindow_browserFrame, "f")[PropertySymbol.asyncTaskManager].startImmediate(id);
        return id;
    }
    /**
     * Mock animation frames with timeouts.
     *
     * @param id ID.
     */
    cancelAnimationFrame(id) {
        // We need to make sure that the ID is an Immediate object, otherwise Node.js might throw an error.
        // This is only necessary if we are in a Node.js environment.
        if (IS_NODE_JS_TIMEOUT_ENVIRONMENT && (!id || id.constructor.name !== 'Immediate')) {
            return;
        }
        TIMER.clearImmediate(id);
        __classPrivateFieldGet(this, _BrowserWindow_browserFrame, "f")[PropertySymbol.asyncTaskManager].endImmediate(id);
    }
    /**
     * Queues a microtask to be executed at a safe time prior to control returning to the browser's event loop.
     *
     * @param callback Function to be executed.
     */
    queueMicrotask(callback) {
        let isAborted = false;
        const taskId = __classPrivateFieldGet(this, _BrowserWindow_browserFrame, "f")[PropertySymbol.asyncTaskManager].startTask(() => (isAborted = true));
        const settings = __classPrivateFieldGet(this, _BrowserWindow_browserFrame, "f").page?.context?.browser?.settings;
        const useTryCatch = !settings ||
            !settings.disableErrorCapturing ||
            settings.errorCapture === BrowserErrorCaptureEnum_js_1.default.tryAndCatch;
        TIMER.queueMicrotask(() => {
            if (!isAborted) {
                if (useTryCatch) {
                    WindowErrorUtility_js_1.default.captureError(this, callback);
                }
                else {
                    callback();
                }
                __classPrivateFieldGet(this, _BrowserWindow_browserFrame, "f")[PropertySymbol.asyncTaskManager].endTask(taskId);
            }
        });
    }
    /**
     * This method provides an easy, logical way to fetch resources asynchronously across the network.
     *
     * @param url URL.
     * @param [init] Init.
     * @returns Promise.
     */
    async fetch(url, init) {
        return await new Fetch_js_1.default({
            browserFrame: __classPrivateFieldGet(this, _BrowserWindow_browserFrame, "f"),
            window: this,
            url,
            init
        }).send();
    }
    /**
     * Creates a Base64-encoded ASCII string from a binary string (i.e., a string in which each character in the string is treated as a byte of binary data).
     *
     * @see https://developer.mozilla.org/en-US/docs/Web/API/btoa
     * @param data Binay data.
     * @returns Base64-encoded string.
     */
    btoa(data) {
        return Base64_js_1.default.btoa(data);
    }
    /**
     * Decodes a string of data which has been encoded using Base64 encoding.
     *
     * @see https://developer.mozilla.org/en-US/docs/Web/API/atob
     * @see https://infra.spec.whatwg.org/#forgiving-base64-encode.
     * @see Https://html.spec.whatwg.org/multipage/webappapis.html#btoa.
     * @param data Binay string.
     * @returns An ASCII string containing decoded data from encodedData.
     */
    atob(data) {
        return Base64_js_1.default.atob(data);
    }
    /**
     * Safely enables cross-origin communication between Window objects; e.g., between a page and a pop-up that it spawned, or between a page and an iframe embedded within it.
     *
     * @param message Message.
     * @param [targetOrigin=*] Target origin.
     * @param _transfer Transfer. Not implemented.
     */
    postMessage(message, targetOrigin = '*', _transfer) {
        // TODO: Implement transfer.
        if (targetOrigin && targetOrigin !== '*' && this.location.origin !== targetOrigin) {
            throw new DOMException_js_1.default(`Failed to execute 'postMessage' on 'Window': The target origin provided ('${targetOrigin}') does not match the recipient window\'s origin ('${this.location.origin}').`, DOMExceptionNameEnum_js_1.default.securityError);
        }
        try {
            JSON.stringify(message);
        }
        catch (error) {
            throw new DOMException_js_1.default(`Failed to execute 'postMessage' on 'Window': The provided message cannot be serialized.`, DOMExceptionNameEnum_js_1.default.invalidStateError);
        }
        this.setTimeout(() => this.dispatchEvent(new MessageEvent_js_1.default('message', {
            data: message,
            origin: __classPrivateFieldGet(this, _BrowserWindow_browserFrame, "f").parentFrame
                ? __classPrivateFieldGet(this, _BrowserWindow_browserFrame, "f").parentFrame.window.location.origin
                : __classPrivateFieldGet(this, _BrowserWindow_browserFrame, "f").window.location.origin,
            source: __classPrivateFieldGet(this, _BrowserWindow_browserFrame, "f").parentFrame
                ? __classPrivateFieldGet(this, _BrowserWindow_browserFrame, "f").parentFrame.window
                : __classPrivateFieldGet(this, _BrowserWindow_browserFrame, "f").window,
            lastEventId: ''
        })));
    }
    /**
     * Resizes the window.
     *
     * @param width Width.
     * @param height Height.
     */
    resizeTo(width, height) {
        if (!width || !height) {
            throw new DOMException_js_1.default(`Failed to execute 'resizeTo' on 'Window': 2 arguments required, but only ${arguments.length} present.`);
        }
        // We can only resize the window if it is a popup.
        if (__classPrivateFieldGet(this, _BrowserWindow_browserFrame, "f")[PropertySymbol.popup]) {
            __classPrivateFieldGet(this, _BrowserWindow_browserFrame, "f").page.setViewport({ width, height });
        }
    }
    /**
     * Resizes the current window by a specified amount.
     *
     * @param width Width.
     * @param height Height.
     */
    resizeBy(width, height) {
        if (!width || !height) {
            throw new DOMException_js_1.default(`Failed to execute 'resizeBy' on 'Window': 2 arguments required, but only ${arguments.length} present.`);
        }
        // We can only resize the window if it is a popup.
        if (__classPrivateFieldGet(this, _BrowserWindow_browserFrame, "f")[PropertySymbol.popup]) {
            const viewport = __classPrivateFieldGet(this, _BrowserWindow_browserFrame, "f").page.viewport;
            __classPrivateFieldGet(this, _BrowserWindow_browserFrame, "f").page.setViewport({
                width: viewport.width + width,
                height: viewport.height + height
            });
        }
    }
    /**
     * Setup of VM context.
     */
    [(_BrowserWindow_browserFrame = new WeakMap(), _BrowserWindow_innerWidth = new WeakMap(), _BrowserWindow_innerHeight = new WeakMap(), _BrowserWindow_outerWidth = new WeakMap(), _BrowserWindow_outerHeight = new WeakMap(), _BrowserWindow_devicePixelRatio = new WeakMap(), _BrowserWindow_zeroTimeouts = new WeakMap(), _BrowserWindow_instances = new WeakSet(), _b = PropertySymbol.captureEventListenerCount, _c = PropertySymbol.mutationObservers, _d = PropertySymbol.readyStateManager, _e = PropertySymbol.asyncTaskManager, PropertySymbol.location, PropertySymbol.history, PropertySymbol.navigator, PropertySymbol.screen, PropertySymbol.sessionStorage, PropertySymbol.localStorage, PropertySymbol.setupVMContext)]() {
        if (!vm_1.default.isContext(this)) {
            vm_1.default.createContext(this);
            // Sets global properties from the VM to the Window object.
            // Otherwise "this.Array" will be undefined for example.
            VMGlobalPropertyScript_js_1.default.runInContext(this);
        }
    }
    /**
     * Destroys the window.
     */
    [PropertySymbol.destroy]() {
        if (!this.Audio[PropertySymbol.ownerDocument]) {
            return;
        }
        this.closed = true;
        this[PropertySymbol.asyncTaskManager] = null;
        this.Audio[PropertySymbol.ownerDocument] = null;
        this.Image[PropertySymbol.ownerDocument] = null;
        this.DocumentFragment[PropertySymbol.ownerDocument] = null;
        this.Text[PropertySymbol.ownerDocument] = null;
        this.Comment[PropertySymbol.ownerDocument] = null;
        const mutationObservers = this[PropertySymbol.mutationObservers];
        for (const mutationObserver of mutationObservers) {
            mutationObserver.disconnect();
        }
        this[PropertySymbol.mutationObservers] = [];
        // Disconnects nodes from the document, so that they can be garbage collected.
        for (const node of this.document[PropertySymbol.childNodes].slice()) {
            // Makes sure that something won't be triggered by the disconnect.
            if (node.disconnectedCallback) {
                delete node.disconnectedCallback;
            }
            this.document.removeChild(node);
        }
        if (this.customElements[PropertySymbol.destroy]) {
            this.customElements[PropertySymbol.destroy]();
        }
        this.document[PropertySymbol.activeElement] = null;
        this.document[PropertySymbol.nextActiveElement] = null;
        this.document[PropertySymbol.currentScript] = null;
        this.document[PropertySymbol.selection] = null;
        WindowBrowserSettingsReader_js_1.default.removeSettings(this);
    }
}
_a = BrowserWindow, _BrowserWindow_bindToThisScope = function _BrowserWindow_bindToThisScope() {
    const propertyDescriptors = Object.assign(Object.getOwnPropertyDescriptors(EventTarget_js_1.default.prototype), Object.getOwnPropertyDescriptors(_a.prototype));
    for (const key of Object.keys(propertyDescriptors)) {
        const descriptor = propertyDescriptors[key];
        if (descriptor.get || descriptor.set) {
            Object.defineProperty(this, key, {
                configurable: true,
                enumerable: true,
                get: descriptor.get?.bind(this),
                set: descriptor.set?.bind(this)
            });
        }
        else if (key !== 'constructor' &&
            key[0] !== '_' &&
            key[0] === key[0].toLowerCase() &&
            typeof this[key] === 'function' &&
            !this[key].toString().startsWith('class ')) {
            this[key] = this[key].bind(this);
        }
    }
};
exports.default = BrowserWindow;
//# sourceMappingURL=BrowserWindow.cjs.map