"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const PropertySymbol = __importStar(require("../PropertySymbol.cjs"));
const Storage_js_1 = __importDefault(require("./Storage.cjs"));
/**
 * Dataset factory.
 *
 * Reference:
 * https://developer.mozilla.org/en-US/docs/Web/API/HTMLElement/storage
 */
class StorageFactory {
    /**
     * Creates a new storage.
     */
    static createStorage() {
        // Documentation for Proxy:
        // https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Proxy
        return new Proxy(new Storage_js_1.default(), {
            get(storage, key) {
                if (Storage_js_1.default.prototype.hasOwnProperty(key)) {
                    const descriptor = Object.getOwnPropertyDescriptor(Storage_js_1.default.prototype, key);
                    if (descriptor.value !== undefined) {
                        if (typeof descriptor.value === 'function') {
                            return storage[key].bind(storage);
                        }
                        return descriptor.value;
                    }
                    if (descriptor.get) {
                        return descriptor.get.call(storage);
                    }
                    return storage[key];
                }
                return storage[PropertySymbol.data][key];
            },
            set(storage, key, value) {
                if (Storage_js_1.default.prototype.hasOwnProperty(key)) {
                    return true;
                }
                storage[PropertySymbol.data][key] = String(value);
                return true;
            },
            deleteProperty(storage, key) {
                if (Storage_js_1.default.prototype.hasOwnProperty(key)) {
                    return true;
                }
                return delete storage[PropertySymbol.data][key];
            },
            ownKeys(storage) {
                return Object.keys(storage[PropertySymbol.data]);
            },
            has(storage, key) {
                return storage[PropertySymbol.data][key] !== undefined;
            },
            defineProperty(storage, key, descriptor) {
                if (Storage_js_1.default.prototype.hasOwnProperty(key)) {
                    if (descriptor.get || descriptor.set) {
                        Object.defineProperty(storage, key, {
                            ...descriptor,
                            get: descriptor.get ? descriptor.get.bind(storage) : undefined,
                            set: descriptor.set ? descriptor.set.bind(storage) : undefined
                        });
                    }
                    else {
                        Object.defineProperty(storage, key, {
                            ...descriptor,
                            value: typeof descriptor.value === 'function'
                                ? descriptor.value.bind(storage)
                                : descriptor.value
                        });
                    }
                    return true;
                }
                if (descriptor.value === undefined) {
                    return false;
                }
                storage[PropertySymbol.data][key] = String(descriptor.value);
                return true;
            },
            getOwnPropertyDescriptor(storage, key) {
                if (Storage_js_1.default.prototype.hasOwnProperty(key) ||
                    storage[PropertySymbol.data][key] === undefined) {
                    return;
                }
                return {
                    value: storage[PropertySymbol.data][key],
                    writable: true,
                    enumerable: true,
                    configurable: true
                };
            }
        });
    }
}
exports.default = StorageFactory;
//# sourceMappingURL=StorageFactory.cjs.map