"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var _HTMLIFrameElementPageLoader_element, _HTMLIFrameElementPageLoader_contentWindowContainer, _HTMLIFrameElementPageLoader_browserParentFrame, _HTMLIFrameElementPageLoader_browserIFrame, _HTMLIFrameElementPageLoader_srcdoc;
Object.defineProperty(exports, "__esModule", { value: true });
const Event_js_1 = __importDefault(require("../../event/Event.cjs"));
const PropertySymbol = __importStar(require("../../PropertySymbol.cjs"));
const CrossOriginBrowserWindow_js_1 = __importDefault(require("../../window/CrossOriginBrowserWindow.cjs"));
const WindowErrorUtility_js_1 = __importDefault(require("../../window/WindowErrorUtility.cjs"));
const DOMException_js_1 = __importDefault(require("../../exception/DOMException.cjs"));
const DOMExceptionNameEnum_js_1 = __importDefault(require("../../exception/DOMExceptionNameEnum.cjs"));
const BrowserFrameURL_js_1 = __importDefault(require("../../browser/utilities/BrowserFrameURL.cjs"));
const BrowserFrameFactory_js_1 = __importDefault(require("../../browser/utilities/BrowserFrameFactory.cjs"));
/**
 * HTML Iframe page loader.
 */
class HTMLIFrameElementPageLoader {
    /**
     * Constructor.
     *
     * @param options Options.
     * @param options.element Iframe element.
     * @param options.browserParentFrame Main browser frame.
     * @param options.contentWindowContainer Content window container.
     * @param options.contentWindowContainer.window Content window.
     */
    constructor(options) {
        _HTMLIFrameElementPageLoader_element.set(this, void 0);
        _HTMLIFrameElementPageLoader_contentWindowContainer.set(this, void 0);
        _HTMLIFrameElementPageLoader_browserParentFrame.set(this, void 0);
        _HTMLIFrameElementPageLoader_browserIFrame.set(this, void 0);
        _HTMLIFrameElementPageLoader_srcdoc.set(this, null);
        __classPrivateFieldSet(this, _HTMLIFrameElementPageLoader_element, options.element, "f");
        __classPrivateFieldSet(this, _HTMLIFrameElementPageLoader_contentWindowContainer, options.contentWindowContainer, "f");
        __classPrivateFieldSet(this, _HTMLIFrameElementPageLoader_browserParentFrame, options.browserParentFrame, "f");
    }
    /**
     * Loads an iframe page.
     */
    loadPage() {
        if (!__classPrivateFieldGet(this, _HTMLIFrameElementPageLoader_element, "f")[PropertySymbol.isConnected]) {
            this.unloadPage();
            return;
        }
        const srcdoc = __classPrivateFieldGet(this, _HTMLIFrameElementPageLoader_element, "f").getAttribute('srcdoc');
        const window = __classPrivateFieldGet(this, _HTMLIFrameElementPageLoader_element, "f")[PropertySymbol.ownerDocument][PropertySymbol.ownerWindow];
        if (srcdoc !== null) {
            if (__classPrivateFieldGet(this, _HTMLIFrameElementPageLoader_srcdoc, "f") === srcdoc) {
                return;
            }
            this.unloadPage();
            __classPrivateFieldSet(this, _HTMLIFrameElementPageLoader_browserIFrame, BrowserFrameFactory_js_1.default.createChildFrame(__classPrivateFieldGet(this, _HTMLIFrameElementPageLoader_browserParentFrame, "f")), "f");
            __classPrivateFieldGet(this, _HTMLIFrameElementPageLoader_browserIFrame, "f").url = 'about:srcdoc';
            __classPrivateFieldGet(this, _HTMLIFrameElementPageLoader_contentWindowContainer, "f").window = __classPrivateFieldGet(this, _HTMLIFrameElementPageLoader_browserIFrame, "f").window;
            __classPrivateFieldGet(this, _HTMLIFrameElementPageLoader_browserIFrame, "f").window.top = __classPrivateFieldGet(this, _HTMLIFrameElementPageLoader_browserParentFrame, "f").window.top;
            __classPrivateFieldGet(this, _HTMLIFrameElementPageLoader_browserIFrame, "f").window.parent = __classPrivateFieldGet(this, _HTMLIFrameElementPageLoader_browserParentFrame, "f").window;
            __classPrivateFieldGet(this, _HTMLIFrameElementPageLoader_browserIFrame, "f").window.document.open();
            __classPrivateFieldGet(this, _HTMLIFrameElementPageLoader_browserIFrame, "f").window.document.write(srcdoc);
            __classPrivateFieldSet(this, _HTMLIFrameElementPageLoader_srcdoc, srcdoc, "f");
            __classPrivateFieldGet(this, _HTMLIFrameElementPageLoader_element, "f")[PropertySymbol.ownerDocument][PropertySymbol.ownerWindow].requestAnimationFrame(() => __classPrivateFieldGet(this, _HTMLIFrameElementPageLoader_element, "f").dispatchEvent(new Event_js_1.default('load')));
            return;
        }
        if (__classPrivateFieldGet(this, _HTMLIFrameElementPageLoader_srcdoc, "f") !== null) {
            this.unloadPage();
        }
        const originURL = __classPrivateFieldGet(this, _HTMLIFrameElementPageLoader_browserParentFrame, "f").window.location;
        const targetURL = BrowserFrameURL_js_1.default.getRelativeURL(__classPrivateFieldGet(this, _HTMLIFrameElementPageLoader_browserParentFrame, "f"), __classPrivateFieldGet(this, _HTMLIFrameElementPageLoader_element, "f").src);
        if (__classPrivateFieldGet(this, _HTMLIFrameElementPageLoader_browserIFrame, "f") && __classPrivateFieldGet(this, _HTMLIFrameElementPageLoader_browserIFrame, "f").window.location.href === targetURL.href) {
            return;
        }
        if (__classPrivateFieldGet(this, _HTMLIFrameElementPageLoader_browserParentFrame, "f").page.context.browser.settings.disableIframePageLoading) {
            WindowErrorUtility_js_1.default.dispatchError(__classPrivateFieldGet(this, _HTMLIFrameElementPageLoader_element, "f"), new DOMException_js_1.default(`Failed to load iframe page "${targetURL.href}". Iframe page loading is disabled.`, DOMExceptionNameEnum_js_1.default.notSupportedError));
            return;
        }
        // Iframes has a special rule for CORS and doesn't allow access between frames when the origin is different.
        const isSameOrigin = originURL.origin === targetURL.origin || targetURL.origin === 'null';
        const parentWindow = isSameOrigin ? window : new CrossOriginBrowserWindow_js_1.default(window);
        __classPrivateFieldSet(this, _HTMLIFrameElementPageLoader_browserIFrame, __classPrivateFieldGet(this, _HTMLIFrameElementPageLoader_browserIFrame, "f") ?? BrowserFrameFactory_js_1.default.createChildFrame(__classPrivateFieldGet(this, _HTMLIFrameElementPageLoader_browserParentFrame, "f")), "f");
        __classPrivateFieldGet(this, _HTMLIFrameElementPageLoader_browserIFrame, "f").window.top =
            parentWindow;
        __classPrivateFieldGet(this, _HTMLIFrameElementPageLoader_browserIFrame, "f").window.parent =
            parentWindow;
        __classPrivateFieldGet(this, _HTMLIFrameElementPageLoader_browserIFrame, "f")
            .goto(targetURL.href, {
            referrer: originURL.origin,
            referrerPolicy: __classPrivateFieldGet(this, _HTMLIFrameElementPageLoader_element, "f").referrerPolicy
        })
            .then(() => __classPrivateFieldGet(this, _HTMLIFrameElementPageLoader_element, "f").dispatchEvent(new Event_js_1.default('load')))
            .catch((error) => WindowErrorUtility_js_1.default.dispatchError(__classPrivateFieldGet(this, _HTMLIFrameElementPageLoader_element, "f"), error));
        __classPrivateFieldGet(this, _HTMLIFrameElementPageLoader_contentWindowContainer, "f").window = isSameOrigin
            ? __classPrivateFieldGet(this, _HTMLIFrameElementPageLoader_browserIFrame, "f").window
            : new CrossOriginBrowserWindow_js_1.default(__classPrivateFieldGet(this, _HTMLIFrameElementPageLoader_browserIFrame, "f").window, window);
    }
    /**
     * Unloads an iframe page.
     */
    unloadPage() {
        if (__classPrivateFieldGet(this, _HTMLIFrameElementPageLoader_browserIFrame, "f")) {
            BrowserFrameFactory_js_1.default.destroyFrame(__classPrivateFieldGet(this, _HTMLIFrameElementPageLoader_browserIFrame, "f"));
            __classPrivateFieldSet(this, _HTMLIFrameElementPageLoader_browserIFrame, null, "f");
        }
        __classPrivateFieldGet(this, _HTMLIFrameElementPageLoader_contentWindowContainer, "f").window = null;
        __classPrivateFieldSet(this, _HTMLIFrameElementPageLoader_srcdoc, null, "f");
    }
}
_HTMLIFrameElementPageLoader_element = new WeakMap(), _HTMLIFrameElementPageLoader_contentWindowContainer = new WeakMap(), _HTMLIFrameElementPageLoader_browserParentFrame = new WeakMap(), _HTMLIFrameElementPageLoader_browserIFrame = new WeakMap(), _HTMLIFrameElementPageLoader_srcdoc = new WeakMap();
exports.default = HTMLIFrameElementPageLoader;
//# sourceMappingURL=HTMLIFrameElementPageLoader.cjs.map