import Event from '../../event/Event.cjs';
import * as PropertySymbol from '../../PropertySymbol.cjs';
import BrowserWindow from '../../window/BrowserWindow.cjs';
import Document from '../document/Document.cjs';
import HTMLElement from '../html-element/HTMLElement.cjs';
import Node from '../node/Node.cjs';
import NamedNodeMap from '../../named-node-map/NamedNodeMap.cjs';
import CrossOriginBrowserWindow from '../../window/CrossOriginBrowserWindow.cjs';
import IBrowserFrame from '../../browser/types/IBrowserFrame.cjs';
import DOMTokenList from '../../dom-token-list/DOMTokenList.cjs';
/**
 * HTML Iframe Element.
 *
 * Reference:
 * https://developer.mozilla.org/en-US/docs/Web/API/HTMLIFrameElement.
 */
export default class HTMLIFrameElement extends HTMLElement {
    #private;
    cloneNode: (deep?: boolean) => HTMLIFrameElement;
    onload: (event: Event) => void | null;
    onerror: (event: Event) => void | null;
    [PropertySymbol.attributes]: NamedNodeMap;
    [PropertySymbol.sandbox]: DOMTokenList;
    /**
     * Constructor.
     *
     * @param browserFrame Browser frame.
     */
    constructor(browserFrame: IBrowserFrame);
    /**
     * Returns source.
     *
     * @returns Source.
     */
    get src(): string;
    /**
     * Sets source.
     *
     * @param src Source.
     */
    set src(src: string);
    /**
     * Returns allow.
     *
     * @returns Allow.
     */
    get allow(): string;
    /**
     * Sets allow.
     *
     * @param allow Allow.
     */
    set allow(allow: string);
    /**
     * Returns height.
     *
     * @returns Height.
     */
    get height(): string;
    /**
     * Sets height.
     *
     * @param height Height.
     */
    set height(height: string);
    /**
     * Returns width.
     *
     * @returns Width.
     */
    get width(): string;
    /**
     * Sets width.
     *
     * @param width Width.
     */
    set width(width: string);
    /**
     * Returns name.
     *
     * @returns Name.
     */
    get name(): string;
    /**
     * Sets name.
     *
     * @param name Name.
     */
    set name(name: string);
    /**
     * Returns sandbox.
     *
     * @returns Sandbox.
     */
    get sandbox(): DOMTokenList;
    /**
     * Sets sandbox.
     */
    set sandbox(sandbox: string);
    /**
     * Returns srcdoc.
     *
     * @returns Srcdoc.
     */
    get srcdoc(): string;
    /**
     * Sets srcdoc.
     *
     * @param srcdoc Srcdoc.
     */
    set srcdoc(srcdoc: string);
    /**
     * Returns referrer policy.
     */
    get referrerPolicy(): string;
    /**
     * Sets referrer policy.
     *
     * @param referrerPolicy Referrer policy.
     */
    set referrerPolicy(referrerPolicy: string);
    /**
     * Returns content document.
     *
     * @returns Content document.
     */
    get contentDocument(): Document | null;
    /**
     * Returns content window.
     *
     * @returns Content window.
     */
    get contentWindow(): BrowserWindow | CrossOriginBrowserWindow | null;
    /**
     * @override
     */
    [PropertySymbol.connectToNode](parentNode?: Node): void;
    /**
     * @override
     */
    [PropertySymbol.cloneNode](deep?: boolean): HTMLIFrameElement;
}
//# sourceMappingURL=HTMLIFrameElement.d.ts.map