import Event from '../../event/Event.cjs';
import HTMLElement from '../html-element/HTMLElement.cjs';
import * as PropertySymbol from '../../PropertySymbol.cjs';
/**
 * HTML Dialog Element.
 *
 * Reference:
 * https://developer.mozilla.org/en-US/docs/Web/API/HTMLDialogElement.
 */
export default class HTMLDialogElement extends HTMLElement {
    [PropertySymbol.returnValue]: string;
    oncancel: (event: Event) => void | null;
    onclose: (event: Event) => void | null;
    /**
     * Returns return value.
     *
     * @returns Return value.
     */
    get returnValue(): string;
    /**
     * Sets return value.
     *
     * @param value Return value.
     */
    set returnValue(value: string);
    /**
     * Sets the "open" attribute.
     *
     * @param open Open.
     */
    set open(open: boolean);
    /**
     * Returns open.
     *
     * @returns Open.
     */
    get open(): boolean;
    /**
     * Closes the dialog.
     *
     * @param [returnValue] ReturnValue.
     */
    close(returnValue?: string): void;
    /**
     * Shows the modal.
     */
    showModal(): void;
    /**
     * Shows the dialog.
     */
    show(): void;
}
//# sourceMappingURL=HTMLDialogElement.d.ts.map