"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const NodeTypeEnum_js_1 = __importDefault(require("../node/NodeTypeEnum.cjs"));
const PropertySymbol = __importStar(require("../../PropertySymbol.cjs"));
const NodeUtility_js_1 = __importDefault(require("../node/NodeUtility.cjs"));
const DOMException_js_1 = __importDefault(require("../../exception/DOMException.cjs"));
const DOMExceptionNameEnum_js_1 = __importDefault(require("../../exception/DOMExceptionNameEnum.cjs"));
const NAMED_ITEM_ATTRIBUTES = ['id', 'name'];
/**
 * Element utility.
 */
class ElementUtility {
    /**
     * Handles appending a child element to the "children" property.
     *
     * @param ancestorNode Ancestor node.
     * @param node Node to append.
     * @param [options] Options.
     * @param [options.disableAncestorValidation] Disables validation for checking if the node is an ancestor of the ancestorNode.
     * @returns Appended node.
     */
    static appendChild(ancestorNode, node, options) {
        if (node[PropertySymbol.nodeType] === NodeTypeEnum_js_1.default.elementNode && node !== ancestorNode) {
            if (!options?.disableAncestorValidation &&
                NodeUtility_js_1.default.isInclusiveAncestor(node, ancestorNode)) {
                throw new DOMException_js_1.default("Failed to execute 'appendChild' on 'Node': The new node is a parent of the node to insert to.", DOMExceptionNameEnum_js_1.default.domException);
            }
            if (node[PropertySymbol.parentNode]) {
                const parentNodeChildren = (node[PropertySymbol.parentNode][PropertySymbol.children]);
                if (parentNodeChildren) {
                    const index = parentNodeChildren.indexOf(node);
                    if (index !== -1) {
                        for (const attributeName of NAMED_ITEM_ATTRIBUTES) {
                            const attribute = node[PropertySymbol.attributes].getNamedItem(attributeName);
                            if (attribute) {
                                parentNodeChildren[PropertySymbol.removeNamedItem](node, attribute[PropertySymbol.value]);
                            }
                        }
                        parentNodeChildren.splice(index, 1);
                    }
                }
            }
            const ancestorNodeChildren = (ancestorNode[PropertySymbol.children]);
            for (const attributeName of NAMED_ITEM_ATTRIBUTES) {
                const attribute = node[PropertySymbol.attributes].getNamedItem(attributeName);
                if (attribute) {
                    ancestorNodeChildren[PropertySymbol.appendNamedItem](node, attribute[PropertySymbol.value]);
                }
            }
            ancestorNodeChildren.push(node);
            NodeUtility_js_1.default.appendChild(ancestorNode, node, { disableAncestorValidation: true });
        }
        else {
            NodeUtility_js_1.default.appendChild(ancestorNode, node, options);
        }
        return node;
    }
    /**
     * Handles removing a child element from the "children" property.
     *
     * @param ancestorNode Ancestor node.
     * @param node Node.
     * @returns Removed node.
     */
    static removeChild(ancestorNode, node) {
        if (node[PropertySymbol.nodeType] === NodeTypeEnum_js_1.default.elementNode) {
            const ancestorNodeChildren = (ancestorNode[PropertySymbol.children]);
            const index = ancestorNodeChildren.indexOf(node);
            if (index !== -1) {
                for (const attributeName of NAMED_ITEM_ATTRIBUTES) {
                    const attribute = node[PropertySymbol.attributes].getNamedItem(attributeName);
                    if (attribute) {
                        ancestorNodeChildren[PropertySymbol.removeNamedItem](node, attribute[PropertySymbol.value]);
                    }
                }
                ancestorNodeChildren.splice(index, 1);
            }
        }
        NodeUtility_js_1.default.removeChild(ancestorNode, node);
        return node;
    }
    /**
     *
     * Handles inserting a child element to the "children" property.
     *
     * @param ancestorNode Ancestor node.
     * @param newNode Node to insert.
     * @param referenceNode Node to insert before.
     * @param [options] Options.
     * @param [options.disableAncestorValidation] Disables validation for checking if the node is an ancestor of the ancestorNode.
     * @returns Inserted node.
     */
    static insertBefore(ancestorNode, newNode, referenceNode, options) {
        if (newNode === referenceNode) {
            return newNode;
        }
        // NodeUtility.insertBefore() will call appendChild() for the scenario where "referenceNode" is "null" or "undefined"
        if (newNode[PropertySymbol.nodeType] === NodeTypeEnum_js_1.default.elementNode && referenceNode) {
            if (!options?.disableAncestorValidation &&
                NodeUtility_js_1.default.isInclusiveAncestor(newNode, ancestorNode)) {
                throw new DOMException_js_1.default("Failed to execute 'insertBefore' on 'Node': The new node is a parent of the node to insert to.", DOMExceptionNameEnum_js_1.default.domException);
            }
            if (newNode[PropertySymbol.parentNode]) {
                const parentNodeChildren = (newNode[PropertySymbol.parentNode][PropertySymbol.children]);
                if (parentNodeChildren) {
                    const index = parentNodeChildren.indexOf(newNode);
                    if (index !== -1) {
                        for (const attributeName of NAMED_ITEM_ATTRIBUTES) {
                            const attribute = newNode[PropertySymbol.attributes].getNamedItem(attributeName);
                            if (attribute) {
                                parentNodeChildren[PropertySymbol.removeNamedItem](newNode, attribute[PropertySymbol.value]);
                            }
                        }
                        parentNodeChildren.splice(index, 1);
                    }
                }
                const parentChildNodes = ancestorNode[PropertySymbol.childNodes];
                if (parentChildNodes) {
                    const index = parentChildNodes.indexOf(newNode);
                    if (index !== -1) {
                        parentChildNodes.splice(index, 1);
                    }
                }
            }
            const ancestorNodeChildren = (ancestorNode[PropertySymbol.children]);
            if (referenceNode[PropertySymbol.nodeType] === NodeTypeEnum_js_1.default.elementNode) {
                const index = ancestorNodeChildren.indexOf(referenceNode);
                if (index !== -1) {
                    ancestorNodeChildren.splice(index, 0, newNode);
                }
            }
            else {
                ancestorNodeChildren.length = 0;
                for (const node of ancestorNode[PropertySymbol.childNodes]) {
                    if (node === referenceNode) {
                        ancestorNodeChildren.push(newNode);
                    }
                    if (node[PropertySymbol.nodeType] === NodeTypeEnum_js_1.default.elementNode) {
                        ancestorNodeChildren.push(node);
                    }
                }
            }
            for (const attributeName of NAMED_ITEM_ATTRIBUTES) {
                const attribute = newNode[PropertySymbol.attributes].getNamedItem(attributeName);
                if (attribute) {
                    ancestorNodeChildren[PropertySymbol.appendNamedItem](newNode, attribute[PropertySymbol.value]);
                }
            }
            NodeUtility_js_1.default.insertBefore(ancestorNode, newNode, referenceNode, {
                disableAncestorValidation: true
            });
        }
        else {
            NodeUtility_js_1.default.insertBefore(ancestorNode, newNode, referenceNode, options);
        }
        return newNode;
    }
}
exports.default = ElementUtility;
//# sourceMappingURL=ElementUtility.cjs.map