/// <reference types="node" />
import { URLSearchParams } from 'url';
import * as PropertySymbol from './PropertySymbol.cjs';
import Browser from './browser/Browser.cjs';
import BrowserContext from './browser/BrowserContext.cjs';
import BrowserFrame from './browser/BrowserFrame.cjs';
import BrowserPage from './browser/BrowserPage.cjs';
import DetachedBrowser from './browser/detached-browser/DetachedBrowser.cjs';
import DetachedBrowserContext from './browser/detached-browser/DetachedBrowserContext.cjs';
import DetachedBrowserFrame from './browser/detached-browser/DetachedBrowserFrame.cjs';
import DetachedBrowserPage from './browser/detached-browser/DetachedBrowserPage.cjs';
import BrowserErrorCaptureEnum from './browser/enums/BrowserErrorCaptureEnum.cjs';
import BrowserNavigationCrossOriginPolicyEnum from './browser/enums/BrowserNavigationCrossOriginPolicyEnum.cjs';
import Clipboard from './clipboard/Clipboard.cjs';
import ClipboardItem from './clipboard/ClipboardItem.cjs';
import VirtualConsole from './console/VirtualConsole.cjs';
import VirtualConsolePrinter from './console/VirtualConsolePrinter.cjs';
import VirtualConsoleLogLevelEnum from './console/enums/VirtualConsoleLogLevelEnum.cjs';
import VirtualConsoleLogTypeEnum from './console/enums/VirtualConsoleLogTypeEnum.cjs';
import CSSRule from './css/CSSRule.cjs';
import CSSStyleSheet from './css/CSSStyleSheet.cjs';
import CSSStyleDeclaration from './css/declaration/CSSStyleDeclaration.cjs';
import CSSContainerRule from './css/rules/CSSContainerRule.cjs';
import CSSFontFaceRule from './css/rules/CSSFontFaceRule.cjs';
import CSSKeyframeRule from './css/rules/CSSKeyframeRule.cjs';
import CSSKeyframesRule from './css/rules/CSSKeyframesRule.cjs';
import CSSMediaRule from './css/rules/CSSMediaRule.cjs';
import CSSStyleRule from './css/rules/CSSStyleRule.cjs';
import CSSSupportsRule from './css/rules/CSSSupportsRule.cjs';
import CustomElementRegistry from './custom-element/CustomElementRegistry.cjs';
import DOMParser from './dom-parser/DOMParser.cjs';
import DataTransfer from './event/DataTransfer.cjs';
import DataTransferItem from './event/DataTransferItem.cjs';
import DataTransferItemList from './event/DataTransferItemList.cjs';
import Event from './event/Event.cjs';
import EventPhaseEnum from './event/EventPhaseEnum.cjs';
import EventTarget from './event/EventTarget.cjs';
import Touch from './event/Touch.cjs';
import UIEvent from './event/UIEvent.cjs';
import AnimationEvent from './event/events/AnimationEvent.cjs';
import ClipboardEvent from './event/events/ClipboardEvent.cjs';
import CustomEvent from './event/events/CustomEvent.cjs';
import ErrorEvent from './event/events/ErrorEvent.cjs';
import FocusEvent from './event/events/FocusEvent.cjs';
import HashChangeEvent from './event/events/HashChangeEvent.cjs';
import InputEvent from './event/events/InputEvent.cjs';
import KeyboardEvent from './event/events/KeyboardEvent.cjs';
import MediaQueryListEvent from './event/events/MediaQueryListEvent.cjs';
import MouseEvent from './event/events/MouseEvent.cjs';
import ProgressEvent from './event/events/ProgressEvent.cjs';
import SubmitEvent from './event/events/SubmitEvent.cjs';
import TouchEvent from './event/events/TouchEvent.cjs';
import WheelEvent from './event/events/WheelEvent.cjs';
import DOMException from './exception/DOMException.cjs';
import AbortController from './fetch/AbortController.cjs';
import AbortSignal from './fetch/AbortSignal.cjs';
import Headers from './fetch/Headers.cjs';
import Request from './fetch/Request.cjs';
import Response from './fetch/Response.cjs';
import Blob from './file/Blob.cjs';
import File from './file/File.cjs';
import FileReader from './file/FileReader.cjs';
import FormData from './form-data/FormData.cjs';
import History from './history/History.cjs';
import Location from './location/Location.cjs';
import MutationObserver from './mutation-observer/MutationObserver.cjs';
import MutationRecord from './mutation-observer/MutationRecord.cjs';
import Attr from './nodes/attr/Attr.cjs';
import Comment from './nodes/comment/Comment.cjs';
import DocumentFragment from './nodes/document-fragment/DocumentFragment.cjs';
import DocumentType from './nodes/document-type/DocumentType.cjs';
import Document from './nodes/document/Document.cjs';
import DOMRect from './nodes/element/DOMRect.cjs';
import DOMRectReadOnly from './nodes/element/DOMRectReadOnly.cjs';
import Element from './nodes/element/Element.cjs';
import HTMLCollection from './nodes/element/HTMLCollection.cjs';
import HTMLAnchorElement from './nodes/html-anchor-element/HTMLAnchorElement.cjs';
import HTMLAudioElement from './nodes/html-audio-element/HTMLAudioElement.cjs';
import HTMLBaseElement from './nodes/html-base-element/HTMLBaseElement.cjs';
import HTMLButtonElement from './nodes/html-button-element/HTMLButtonElement.cjs';
import HTMLDialogElement from './nodes/html-dialog-element/HTMLDialogElement.cjs';
import HTMLDocument from './nodes/html-document/HTMLDocument.cjs';
import HTMLElement from './nodes/html-element/HTMLElement.cjs';
import HTMLFormControlsCollection from './nodes/html-form-element/HTMLFormControlsCollection.cjs';
import HTMLFormElement from './nodes/html-form-element/HTMLFormElement.cjs';
import HTMLIFrameElement from './nodes/html-iframe-element/HTMLIFrameElement.cjs';
import HTMLImageElement from './nodes/html-image-element/HTMLImageElement.cjs';
import Image from './nodes/html-image-element/Image.cjs';
import FileList from './nodes/html-input-element/FileList.cjs';
import HTMLInputElement from './nodes/html-input-element/HTMLInputElement.cjs';
import HTMLLabelElement from './nodes/html-label-element/HTMLLabelElement.cjs';
import HTMLLinkElement from './nodes/html-link-element/HTMLLinkElement.cjs';
import HTMLMediaElement from './nodes/html-media-element/HTMLMediaElement.cjs';
import HTMLMetaElement from './nodes/html-meta-element/HTMLMetaElement.cjs';
import HTMLOptGroupElement from './nodes/html-opt-group-element/HTMLOptGroupElement.cjs';
import HTMLOptionElement from './nodes/html-option-element/HTMLOptionElement.cjs';
import HTMLScriptElement from './nodes/html-script-element/HTMLScriptElement.cjs';
import HTMLSelectElement from './nodes/html-select-element/HTMLSelectElement.cjs';
import HTMLSlotElement from './nodes/html-slot-element/HTMLSlotElement.cjs';
import HTMLStyleElement from './nodes/html-style-element/HTMLStyleElement.cjs';
import HTMLTemplateElement from './nodes/html-template-element/HTMLTemplateElement.cjs';
import HTMLTextAreaElement from './nodes/html-text-area-element/HTMLTextAreaElement.cjs';
import HTMLTimeElement from './nodes/html-time-element/HTMLTimeElement.cjs';
import HTMLUnknownElement from './nodes/html-unknown-element/HTMLUnknownElement.cjs';
import HTMLVideoElement from './nodes/html-video-element/HTMLVideoElement.cjs';
import Node from './nodes/node/Node.cjs';
import ProcessingInstruction from './nodes/processing-instruction/ProcessingInstruction.cjs';
import ShadowRoot from './nodes/shadow-root/ShadowRoot.cjs';
import SVGDocument from './nodes/svg-document/SVGDocument.cjs';
import SVGElement from './nodes/svg-element/SVGElement.cjs';
import SVGGraphicsElement from './nodes/svg-element/SVGGraphicsElement.cjs';
import SVGSVGElement from './nodes/svg-element/SVGSVGElement.cjs';
import Text from './nodes/text/Text.cjs';
import XMLDocument from './nodes/xml-document/XMLDocument.cjs';
import PermissionStatus from './permissions/PermissionStatus.cjs';
import Permissions from './permissions/Permissions.cjs';
import Range from './range/Range.cjs';
import ResizeObserver from './resize-observer/ResizeObserver.cjs';
import Screen from './screen/Screen.cjs';
import Selection from './selection/Selection.cjs';
import Storage from './storage/Storage.cjs';
import NodeFilter from './tree-walker/NodeFilter.cjs';
import NodeIterator from './tree-walker/NodeIterator.cjs';
import TreeWalker from './tree-walker/TreeWalker.cjs';
import URL from './url/URL.cjs';
import BrowserWindow from './window/BrowserWindow.cjs';
import DetachedWindowAPI from './window/DetachedWindowAPI.cjs';
import GlobalWindow from './window/GlobalWindow.cjs';
import Window from './window/Window.cjs';
import XMLParser from './xml-parser/XMLParser.cjs';
import XMLSerializer from './xml-serializer/XMLSerializer.cjs';
import type IBrowser from './browser/types/IBrowser.cjs';
import type IBrowserContext from './browser/types/IBrowserContext.cjs';
import type IBrowserFrame from './browser/types/IBrowserFrame.cjs';
import type IBrowserPage from './browser/types/IBrowserPage.cjs';
import type IBrowserSettings from './browser/types/IBrowserSettings.cjs';
import type IOptionalBrowserSettings from './browser/types/IOptionalBrowserSettings.cjs';
import type IEventInit from './event/IEventInit.cjs';
import type IEventListener from './event/IEventListener.cjs';
import type ITouchInit from './event/ITouchInit.cjs';
import type IUIEventInit from './event/IUIEventInit.cjs';
import type IAnimationEventInit from './event/events/IAnimationEventInit.cjs';
import type IClipboardEventInit from './event/events/IClipboardEventInit.cjs';
import type ICustomEventInit from './event/events/ICustomEventInit.cjs';
import type IErrorEventInit from './event/events/IErrorEventInit.cjs';
import type IFocusEventInit from './event/events/IFocusEventInit.cjs';
import type IHashChangeEventInit from './event/events/IHashChangeEventInit.cjs';
import type IInputEventInit from './event/events/IInputEventInit.cjs';
import type IKeyboardEventInit from './event/events/IKeyboardEventInit.cjs';
import type IMediaQueryListInit from './event/events/IMediaQueryListInit.cjs';
import type IMouseEventInit from './event/events/IMouseEventInit.cjs';
import type IProgressEventInit from './event/events/IProgressEventInit.cjs';
import type ISubmitEventInit from './event/events/ISubmitEventInit.cjs';
import type ITouchEventInit from './event/events/ITouchEventInit.cjs';
import type IWheelEventInit from './event/events/IWheelEventInit.cjs';
export type { IAnimationEventInit, IBrowser, IBrowserContext, IBrowserFrame, IBrowserPage, IBrowserSettings, IClipboardEventInit, ICustomEventInit, IErrorEventInit, IEventInit, IEventListener, IFocusEventInit, IHashChangeEventInit, IInputEventInit, IKeyboardEventInit, IMediaQueryListInit, IMouseEventInit, IOptionalBrowserSettings, IProgressEventInit, ISubmitEventInit, ITouchEventInit, ITouchInit, IUIEventInit, IWheelEventInit };
export { AbortController, AbortSignal, AnimationEvent, Attr, Blob, Browser, BrowserContext, BrowserErrorCaptureEnum, BrowserFrame, BrowserNavigationCrossOriginPolicyEnum, BrowserPage, BrowserWindow, CSSContainerRule, CSSFontFaceRule, CSSKeyframeRule, CSSKeyframesRule, CSSMediaRule, CSSRule, CSSStyleDeclaration, CSSStyleRule, CSSStyleSheet, CSSSupportsRule, Clipboard, ClipboardEvent, ClipboardItem, Comment, CustomElementRegistry, CustomEvent, DOMException, DOMParser, DOMRect, DOMRectReadOnly, DataTransfer, DataTransferItem, DataTransferItemList, DetachedBrowser, DetachedBrowserContext, DetachedBrowserFrame, DetachedBrowserPage, DetachedWindowAPI, Document, DocumentFragment, DocumentType, Element, ErrorEvent, Event, EventPhaseEnum, EventTarget, File, FileList, FileReader, FocusEvent, FormData, GlobalWindow, HTMLAnchorElement, HTMLElement as HTMLAreaElement, HTMLAudioElement, HTMLElement as HTMLBRElement, HTMLBaseElement, HTMLElement as HTMLBodyElement, HTMLButtonElement, HTMLElement as HTMLCanvasElement, HTMLCollection, HTMLElement as HTMLDListElement, HTMLElement as HTMLDataElement, HTMLElement as HTMLDataListElement, HTMLElement as HTMLDetailsElement, HTMLDialogElement, HTMLElement as HTMLDirectoryElement, HTMLElement as HTMLDivElement, HTMLDocument, HTMLElement, HTMLElement as HTMLEmbedElement, HTMLElement as HTMLFieldSetElement, HTMLElement as HTMLFontElement, HTMLFormControlsCollection, HTMLFormElement, HTMLElement as HTMLFrameElement, HTMLElement as HTMLFrameSetElement, HTMLElement as HTMLHRElement, HTMLElement as HTMLHeadElement, HTMLElement as HTMLHeadingElement, HTMLElement as HTMLHtmlElement, HTMLIFrameElement, HTMLImageElement, HTMLInputElement, HTMLElement as HTMLLElement, HTMLLabelElement, HTMLElement as HTMLLegendElement, HTMLLinkElement, HTMLElement as HTMLMapElement, HTMLElement as HTMLMarqueeElement, HTMLMediaElement, HTMLElement as HTMLMenuElement, HTMLMetaElement, HTMLElement as HTMLMeterElement, HTMLElement as HTMLModElement, HTMLElement as HTMLOListElement, HTMLElement as HTMLObjectElement, HTMLOptGroupElement, HTMLOptionElement, HTMLElement as HTMLOutputElement, HTMLElement as HTMLParagraphElement, HTMLElement as HTMLParamElement, HTMLElement as HTMLPictureElement, HTMLElement as HTMLPreElement, HTMLElement as HTMLProgressElement, HTMLElement as HTMLQuoteElement, HTMLScriptElement, HTMLSelectElement, HTMLSlotElement, HTMLElement as HTMLSourceElement, HTMLElement as HTMLSpanElement, HTMLStyleElement, HTMLElement as HTMLTableCaptionElement, HTMLElement as HTMLTableCellElement, HTMLElement as HTMLTableColElement, HTMLElement as HTMLTableElement, HTMLElement as HTMLTableRowElement, HTMLElement as HTMLTableSectionElement, HTMLTemplateElement, HTMLTextAreaElement, HTMLTimeElement, HTMLElement as HTMLTitleElement, HTMLElement as HTMLTrackElement, HTMLElement as HTMLUListElement, HTMLUnknownElement, HTMLVideoElement, HashChangeEvent, Headers, History, Image, InputEvent, KeyboardEvent, Location, MediaQueryListEvent, MouseEvent, MutationObserver, MutationRecord, Node, NodeFilter, NodeIterator, PermissionStatus, Permissions, ProcessingInstruction, ProgressEvent, PropertySymbol, Range, Request, ResizeObserver, Response, SVGDocument, SVGElement, SVGGraphicsElement, SVGSVGElement, Screen, Selection, ShadowRoot, Storage, SubmitEvent, Text, Touch, TouchEvent, TreeWalker, UIEvent, URL, URLSearchParams, VirtualConsole, VirtualConsoleLogLevelEnum, VirtualConsoleLogTypeEnum, VirtualConsolePrinter, WheelEvent, Window, XMLDocument, XMLParser, XMLSerializer };
//# sourceMappingURL=index.d.ts.map