"use strict";
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var _CookieContainer_cookies;
Object.defineProperty(exports, "__esModule", { value: true });
const CookieExpireUtility_js_1 = __importDefault(require("./urilities/CookieExpireUtility.cjs"));
const CookieURLUtility_js_1 = __importDefault(require("./urilities/CookieURLUtility.cjs"));
/**
 * Cookie Container.
 *
 * @see https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Cookie.
 * @see https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Set-Cookie.
 */
class CookieContainer {
    constructor() {
        _CookieContainer_cookies.set(this, []);
    }
    /**
     * Adds cookies.
     *
     * @param cookies Cookies.
     */
    addCookies(cookies) {
        const indexMap = {};
        const getKey = (cookie) => `${cookie.key}-${cookie.originURL.hostname}-${cookie.path}-${typeof cookie.value}`;
        // Creates a map of cookie key, domain, path and value to index.
        for (let i = 0, max = __classPrivateFieldGet(this, _CookieContainer_cookies, "f").length; i < max; i++) {
            indexMap[getKey(__classPrivateFieldGet(this, _CookieContainer_cookies, "f")[i])] = i;
        }
        for (const cookie of cookies) {
            if (cookie?.key) {
                // Remove existing cookie with same name, domain and path.
                const index = indexMap[getKey(cookie)];
                if (index !== undefined) {
                    __classPrivateFieldGet(this, _CookieContainer_cookies, "f").splice(index, 1);
                }
                if (!CookieExpireUtility_js_1.default.hasExpired(cookie)) {
                    indexMap[getKey(cookie)] = __classPrivateFieldGet(this, _CookieContainer_cookies, "f").length;
                    __classPrivateFieldGet(this, _CookieContainer_cookies, "f").push(cookie);
                }
            }
        }
    }
    /**
     * Returns cookies.
     *
     * @param [url] URL.
     * @param [httpOnly] "true" if only http cookies should be returned.
     * @returns Cookies.
     */
    getCookies(url = null, httpOnly = false) {
        const cookies = [];
        for (const cookie of __classPrivateFieldGet(this, _CookieContainer_cookies, "f")) {
            if (!CookieExpireUtility_js_1.default.hasExpired(cookie) &&
                (!httpOnly || !cookie.httpOnly) &&
                (!url || CookieURLUtility_js_1.default.cookieMatchesURL(cookie, url || cookie.originURL))) {
                cookies.push(cookie);
            }
        }
        return cookies;
    }
}
_CookieContainer_cookies = new WeakMap();
exports.default = CookieContainer;
//# sourceMappingURL=CookieContainer.cjs.map