import INodeFilter from './INodeFilter.js';
import INode from '../nodes/node/INode.js';
/**
 * The NodeIterator object represents the nodes of a document subtree and a position within them.
 *
 * Reference:
 * https://developer.mozilla.org/en-US/docs/Web/API/NodeIterator
 */
export default class NodeIterator {
    root: INode;
    whatToShow: number;
    filter: INodeFilter;
    private readonly _walker;
    /**
     * Constructor.
     *
     * @param root Root.
     * @param [whatToShow] What to show.
     * @param [filter] Filter.
     */
    constructor(root: INode, whatToShow?: number, filter?: INodeFilter);
    /**
     * Moves the current Node to the next visible node in the document order.
     *
     * @returns Current node.
     */
    nextNode(): INode;
    /**
     * Moves the current Node to the previous visible node in the document order, and returns the found node. It also moves the current node to this one. If no such node exists, or if it is before that the root node defined at the object construction, returns null and the current node is not changed.
     *
     * @returns Current node.
     */
    previousNode(): INode;
}
//# sourceMappingURL=NodeIterator.d.ts.map