import HTMLElementNamedNodeMap from '../html-element/HTMLElementNamedNodeMap.js';
/**
 * Named Node Map.
 *
 * @see https://developer.mozilla.org/en-US/docs/Web/API/NamedNodeMap
 */
export default class HTMLOptionElementNamedNodeMap extends HTMLElementNamedNodeMap {
    /**
     * @override
     */
    setNamedItem(item) {
        const replacedItem = super.setNamedItem(item);
        if (!this._ownerElement._dirtyness &&
            item.name === 'selected' &&
            replacedItem?.value !== item.value) {
            const selectNode = this._ownerElement._selectNode;
            this._ownerElement._selectedness = true;
            if (selectNode) {
                selectNode._updateOptionItems(this._ownerElement);
            }
        }
        return replacedItem || null;
    }
    /**
     * @override
     */
    _removeNamedItem(name) {
        const removedItem = super._removeNamedItem(name);
        if (removedItem && !this._ownerElement._dirtyness && removedItem.name === 'selected') {
            const selectNode = this._ownerElement._selectNode;
            this._ownerElement._selectedness = false;
            if (selectNode) {
                selectNode._updateOptionItems();
            }
        }
        return removedItem;
    }
}
//# sourceMappingURL=HTMLOptionElementNamedNodeMap.js.map