import IWindow from '../../window/IWindow.js';
import Event from '../Event.js';
import IMessagePort from '../IMessagePort.js';
import IMessageEventInit from './IMessageEventInit.js';
/**
 * Message event.
 *
 * @see https://developer.mozilla.org/en-US/docs/Web/API/MessageEvent
 */
export default class MessageEvent extends Event {
    readonly data: unknown | null;
    readonly origin: string;
    readonly lastEventId: string;
    readonly source: IWindow | null;
    readonly ports: IMessagePort[];
    /**
     * Constructor.
     *
     * @param type Event type.
     * @param [eventInit] Event init.
     */
    constructor(type: string, eventInit?: IMessageEventInit | null);
}
//# sourceMappingURL=MessageEvent.d.ts.map