import EventTarget from '../../event/EventTarget.cjs';
import MutationListener from '../../mutation-observer/MutationListener.cjs';
import INode from './INode.cjs';
import IDocument from '../document/IDocument.cjs';
import IElement from '../element/IElement.cjs';
import NodeTypeEnum from './NodeTypeEnum.cjs';
import NodeDocumentPositionEnum from './NodeDocumentPositionEnum.cjs';
import INodeList from './INodeList.cjs';
/**
 * Node.
 */
export default class Node extends EventTarget implements INode {
    static _ownerDocument: IDocument;
    static readonly ELEMENT_NODE = NodeTypeEnum.elementNode;
    static readonly ATTRIBUTE_NODE = NodeTypeEnum.attributeNode;
    static readonly TEXT_NODE = NodeTypeEnum.textNode;
    static readonly CDATA_SECTION_NODE = NodeTypeEnum.cdataSectionNode;
    static readonly COMMENT_NODE = NodeTypeEnum.commentNode;
    static readonly DOCUMENT_NODE = NodeTypeEnum.documentNode;
    static readonly DOCUMENT_TYPE_NODE = NodeTypeEnum.documentTypeNode;
    static readonly DOCUMENT_FRAGMENT_NODE = NodeTypeEnum.documentFragmentNode;
    static readonly PROCESSING_INSTRUCTION_NODE = NodeTypeEnum.processingInstructionNode;
    static readonly DOCUMENT_POSITION_CONTAINED_BY = NodeDocumentPositionEnum.containedBy;
    static readonly DOCUMENT_POSITION_CONTAINS = NodeDocumentPositionEnum.contains;
    static readonly DOCUMENT_POSITION_DISCONNECTED = NodeDocumentPositionEnum.disconnect;
    static readonly DOCUMENT_POSITION_FOLLOWING = NodeDocumentPositionEnum.following;
    static readonly DOCUMENT_POSITION_IMPLEMENTATION_SPECIFIC = NodeDocumentPositionEnum.implementationSpecific;
    static readonly DOCUMENT_POSITION_PRECEDING = NodeDocumentPositionEnum.preceding;
    readonly ELEMENT_NODE = NodeTypeEnum.elementNode;
    readonly ATTRIBUTE_NODE = NodeTypeEnum.attributeNode;
    readonly TEXT_NODE = NodeTypeEnum.textNode;
    readonly CDATA_SECTION_NODE = NodeTypeEnum.cdataSectionNode;
    readonly COMMENT_NODE = NodeTypeEnum.commentNode;
    readonly DOCUMENT_NODE = NodeTypeEnum.documentNode;
    readonly DOCUMENT_TYPE_NODE = NodeTypeEnum.documentTypeNode;
    readonly DOCUMENT_FRAGMENT_NODE = NodeTypeEnum.documentFragmentNode;
    readonly PROCESSING_INSTRUCTION_NODE = NodeTypeEnum.processingInstructionNode;
    readonly DOCUMENT_POSITION_CONTAINED_BY = NodeDocumentPositionEnum.containedBy;
    readonly DOCUMENT_POSITION_CONTAINS = NodeDocumentPositionEnum.contains;
    readonly DOCUMENT_POSITION_DISCONNECTED = NodeDocumentPositionEnum.disconnect;
    readonly DOCUMENT_POSITION_FOLLOWING = NodeDocumentPositionEnum.following;
    readonly DOCUMENT_POSITION_IMPLEMENTATION_SPECIFIC = NodeDocumentPositionEnum.implementationSpecific;
    readonly DOCUMENT_POSITION_PRECEDING = NodeDocumentPositionEnum.preceding;
    readonly ownerDocument: IDocument;
    readonly parentNode: INode;
    readonly nodeType: number;
    readonly isConnected: boolean;
    _rootNode: INode;
    _formNode: INode;
    _selectNode: INode;
    _textAreaNode: INode;
    _observers: MutationListener[];
    readonly _childNodes: INodeList<INode>;
    /**
     * Constructor.
     */
    constructor();
    /**
     * Returns `Symbol.toStringTag`.
     *
     * @returns `Symbol.toStringTag`.
     */
    get [Symbol.toStringTag](): string;
    /**
     * Get child nodes.
     *
     * @returns Child nodes list.
     */
    get childNodes(): INodeList<INode>;
    /**
     * Get text value of children.
     *
     * @returns Text content.
     */
    get textContent(): string;
    /**
     * Sets text content.
     *
     * @param _textContent Text content.
     */
    set textContent(_textContent: string);
    /**
     * Node value.
     *
     * @returns Node value.
     */
    get nodeValue(): string;
    /**
     * Sets node value.
     */
    set nodeValue(_nodeValue: string);
    /**
     * Node name.
     *
     * @returns Node name.
     */
    get nodeName(): string;
    /**
     * Previous sibling.
     *
     * @returns Node.
     */
    get previousSibling(): INode;
    /**
     * Next sibling.
     *
     * @returns Node.
     */
    get nextSibling(): INode;
    /**
     * First child.
     *
     * @returns Node.
     */
    get firstChild(): INode;
    /**
     * Last child.
     *
     * @returns Node.
     */
    get lastChild(): INode;
    /**
     * Returns parent element.
     *
     * @returns Element.
     */
    get parentElement(): IElement;
    /**
     * Returns base URI.
     *
     * @returns Base URI.
     */
    get baseURI(): string;
    /**
     * Connected callback.
     */
    connectedCallback?(): void;
    /**
     * Disconnected callback.
     */
    disconnectedCallback?(): void;
    /**
     * Returns "true" if the node has child nodes.
     *
     * @returns "true" if the node has child nodes.
     */
    hasChildNodes(): boolean;
    /**
     * Returns "true" if this node contains the other node.
     *
     * @param otherNode Node to test with.
     * @returns "true" if this node contains the other node.
     */
    contains(otherNode: INode): boolean;
    /**
     * Returns closest root node (Document or ShadowRoot).
     *
     * @param options Options.
     * @param options.composed A Boolean that indicates whether the shadow root should be returned (false, the default), or a root node beyond shadow root (true).
     * @returns Node.
     */
    getRootNode(options?: {
        composed: boolean;
    }): INode;
    /**
     * Clones a node.
     *
     * @param [deep=false] "true" to clone deep.
     * @returns Cloned node.
     */
    cloneNode(deep?: boolean): INode;
    /**
     * Append a child node to childNodes.
     *
     * @param  node Node to append.
     * @returns Appended node.
     */
    appendChild(node: INode): INode;
    /**
     * Remove Child element from childNodes array.
     *
     * @param node Node to remove.
     * @returns Removed node.
     */
    removeChild(node: INode): INode;
    /**
     * Inserts a node before another.
     *
     * @param newNode Node to insert.
     * @param referenceNode Node to insert before.
     * @returns Inserted node.
     */
    insertBefore(newNode: INode, referenceNode: INode | null): INode;
    /**
     * Replaces a node with another.
     *
     * @param newChild New child.
     * @param oldChild Old child.
     * @returns Replaced node.
     */
    replaceChild(newChild: INode, oldChild: INode): INode;
    /**
     * Converts the node to a string.
     *
     * @param listener Listener.
     */
    toString(): string;
    /**
     * Observeres the node.
     * Used by MutationObserver, but it is not part of the HTML standard.
     *
     * @param listener Listener.
     */
    _observe(listener: MutationListener): void;
    /**
     * Stops observing the node.
     * Used by MutationObserver, but it is not part of the HTML standard.
     *
     * @param listener Listener.
     */
    _unobserve(listener: MutationListener): void;
    /**
     * Connects this element to another element.
     *
     * @param parentNode Parent node.
     */
    _connectToNode(parentNode?: INode): void;
    /**
     * Reports the position of its argument node relative to the node on which it is called.
     *
     * @see https://dom.spec.whatwg.org/#dom-node-comparedocumentposition
     * @param otherNode Other node.
     */
    compareDocumentPosition(otherNode: INode): number;
    /**
     * Normalizes the sub-tree of the node, i.e. joins adjacent text nodes, and
     * removes all empty text nodes.
     *
     * @see https://developer.mozilla.org/en-US/docs/Web/API/Node/normalize
     */
    normalize(): void;
    /**
     * Determines whether the given node is equal to the current node.
     *
     * @see https://developer.mozilla.org/en-US/docs/Web/API/Node/isSameNode
     * @param node Node to check.
     * @returns True if the given node is equal to the current node, otherwise false.
     */
    isSameNode(node: INode): boolean;
}
//# sourceMappingURL=Node.d.ts.map